/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.granularity;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.FieldGranularity;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.WriteConflict;

public class FieldGranularityStressTest {
    public AtomicInteger conflictCounter;
    private int transactionCount = 50000000;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.conflictCounter = new AtomicInteger();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void testFieldGranularityCausesNoWriteConflicts() {
        Pair pair = new Pair(0, 0);
        SetLeftThread leftThread = new SetLeftThread(pair);
        SetRightThread rightThread = new SetRightThread(pair);
        TestUtils.startAll((TestThread[])new TestThread[]{leftThread, rightThread});
        TestUtils.joinAll((TestThread[])new TestThread[]{leftThread, rightThread});
        Assert.assertEquals((long)this.transactionCount, (long)pair.getLeft());
        Assert.assertEquals((long)this.transactionCount, (long)pair.getRight());
        Assert.assertEquals((long)0L, (long)this.conflictCounter.get());
    }

    @TransactionalObject
    public static class Pair {
        @FieldGranularity
        private int left;
        @FieldGranularity
        private int right;

        public Pair(int left, int right) {
            this.left = left;
            this.right = right;
        }

        public int getLeft() {
            return this.left;
        }

        public void setLeft(int left) {
            this.left = left;
        }

        public int getRight() {
            return this.right;
        }

        public void setRight(int right) {
            this.right = right;
        }
    }

    class SetRightThread
    extends TestThread {
        final Pair pair;

        SetRightThread(Pair pair) {
            super("SetRightThread");
            this.pair = pair;
        }

        public void doRun() throws Exception {
            for (int k = 0; k < FieldGranularityStressTest.this.transactionCount; ++k) {
                this.updateRight();
                if (k % 5000000 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
        }

        @TransactionalMethod(readonly=false)
        public void updateRight() throws Exception {
            this.pair.setRight(this.pair.getRight() + 1);
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            try {
                tx.prepare();
            }
            catch (WriteConflict conflict) {
                conflict.printStackTrace();
                FieldGranularityStressTest.this.conflictCounter.incrementAndGet();
            }
        }
    }

    class SetLeftThread
    extends TestThread {
        final Pair pair;

        SetLeftThread(Pair pair) {
            super("SetLeftThread");
            this.pair = pair;
        }

        public void doRun() throws Exception {
            for (int k = 0; k < FieldGranularityStressTest.this.transactionCount; ++k) {
                this.updateLeft();
                if (k % 5000000 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
        }

        @TransactionalMethod(readonly=false)
        public void updateLeft() {
            this.pair.setLeft(this.pair.getLeft() + 1);
            Transaction tx = ThreadLocalTransaction.getThreadLocalTransaction();
            try {
                tx.prepare();
            }
            catch (WriteConflict conflict) {
                conflict.printStackTrace();
                FieldGranularityStressTest.this.conflictCounter.incrementAndGet();
            }
        }
    }
}

