/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.isolation;

import java.util.concurrent.atomic.AtomicBoolean;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class AnotherWriteSkewStressTest {
    private int transactionCountPerThread = 10000000;
    private User user1;
    private User user2;
    private AtomicBoolean writeSkewEncountered = new AtomicBoolean();
    private boolean allowWriteSkew;
    private TransferThread[] threads;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.user1 = new User();
        this.user2 = new User();
        this.writeSkewEncountered.set(false);
        this.threads = new TransferThread[2];
        for (int k = 0; k < this.threads.length; ++k) {
            this.threads[k] = new TransferThread(k);
        }
        this.user1.getRandomAccount().inc(1000);
    }

    @Test
    public void allowWriteSkew() {
        this.allowWriteSkew = true;
        TestUtils.startAll((TestThread[])this.threads);
        TestUtils.joinAll((TestThread[])this.threads);
        System.out.println("User1: " + this.user1);
        System.out.println("User2: " + this.user2);
        Assert.assertTrue((boolean)this.writeSkewEncountered.get());
    }

    @Test
    public void disallowedWriteSkew() {
        this.allowWriteSkew = false;
        TestUtils.startAll((TestThread[])this.threads);
        TestUtils.joinAll((TestThread[])this.threads);
        System.out.println("User1: " + this.user1);
        System.out.println("User2: " + this.user2);
        Assert.assertFalse((String)"writeskew detected", (boolean)this.writeSkewEncountered.get());
    }

    public User random(User user1, User user2) {
        return TestUtils.randomBoolean() ? user1 : user2;
    }

    public class User {
        private TransactionalInteger account1 = new TransactionalInteger();
        private TransactionalInteger account2 = new TransactionalInteger();

        public TransactionalInteger getRandomAccount() {
            return TestUtils.randomBoolean() ? this.account1 : this.account2;
        }

        @TransactionalMethod(readonly=true)
        public int getTotal() {
            return this.account1.get() + this.account2.get();
        }

        public String toString() {
            return String.format("User(account1 = %s, account2 = %s)", this.account1.get(), this.account2.get());
        }
    }

    public class TransferThread
    extends TestThread {
        public TransferThread(int id) {
            super("TransferThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < AnotherWriteSkewStressTest.this.transactionCountPerThread; ++k) {
                if (k % 1000000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                if (AnotherWriteSkewStressTest.this.allowWriteSkew) {
                    this.runWithWriteSkewAllowed();
                    continue;
                }
                this.runWithWriteSkewDisallowed();
            }
        }

        @TransactionalMethod(writeSkew=false)
        private void runWithWriteSkewDisallowed() {
            this.doIt();
        }

        @TransactionalMethod(writeSkew=true)
        private void runWithWriteSkewAllowed() {
            this.doIt();
        }

        public void doIt() {
            int amount = TestUtils.randomInt((int)100);
            User from = AnotherWriteSkewStressTest.this.random(AnotherWriteSkewStressTest.this.user1, AnotherWriteSkewStressTest.this.user2);
            User to = AnotherWriteSkewStressTest.this.random(AnotherWriteSkewStressTest.this.user1, AnotherWriteSkewStressTest.this.user2);
            int sum = from.account1.get() + from.account2.get();
            if (sum < 0) {
                AnotherWriteSkewStressTest.this.writeSkewEncountered.set(true);
                System.out.println("writeskew detected");
            }
            if (sum >= amount) {
                from.getRandomAccount().dec(amount);
                to.getRandomAccount().inc(amount);
            }
        }
    }
}

