/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.isolation;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class DirtyReadStressTest {
    private TransactionalInteger ref;
    private int readCount = 5000;
    private int readThreadCount = 10;
    private int modifyThreadCount = 2;
    private volatile boolean readersFinished = false;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.ref = new TransactionalInteger(0);
    }

    @Test
    public void test() {
        TestThread[] modifyThreads = new FailingModifyThread[this.modifyThreadCount];
        for (int k = 0; k < this.modifyThreadCount; ++k) {
            modifyThreads[k] = new FailingModifyThread(k);
        }
        TestThread[] readerThread = new ReadThread[this.readThreadCount];
        for (int k = 0; k < this.readThreadCount; ++k) {
            readerThread[k] = new ReadThread(k);
        }
        TestUtils.startAll((TestThread[])modifyThreads);
        TestUtils.startAll((TestThread[])readerThread);
        TestUtils.joinAll((TestThread[])modifyThreads);
        TestUtils.joinAll((TestThread[])readerThread);
    }

    class ReadThread
    extends TestThread {
        public ReadThread(int threadId) {
            super("ReadThread-" + threadId);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void doRun() {
            try {
                for (int k = 0; k < DirtyReadStressTest.this.readCount; ++k) {
                    if (k % 1000 == 0) {
                        System.out.printf("%s is at %s\n", this.getName(), k);
                    }
                    if (k % 2 == 0) {
                        this.observeUsingReadonlyTransaction();
                    } else {
                        this.observeUsingUpdateTransaction();
                    }
                    TestUtils.sleepRandomMs((int)5);
                }
            }
            finally {
                DirtyReadStressTest.this.readersFinished = true;
            }
        }

        @TransactionalMethod(readonly=true)
        private void observeUsingReadonlyTransaction() {
            this.observe();
        }

        @TransactionalMethod
        private void observeUsingUpdateTransaction() {
            this.observe();
        }

        private void observe() {
            if (DirtyReadStressTest.this.ref.get() % 2 != 0) {
                Assert.fail();
            }
        }
    }

    class FailingModifyThread
    extends TestThread {
        public FailingModifyThread(int threadId) {
            super("FailingModifyThread-" + threadId);
        }

        public void doRun() {
            int k = 0;
            while (!DirtyReadStressTest.this.readersFinished) {
                if (k % 1000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                ++k;
                try {
                    this.modify();
                    Assert.fail();
                }
                catch (DeadTransactionException deadTransactionException) {
                    // empty catch block
                }
                TestUtils.sleepRandomMs((int)10);
            }
        }

        @TransactionalMethod
        private void modify() {
            DirtyReadStressTest.this.ref.inc();
            TestUtils.sleepRandomMs((int)30);
            ThreadLocalTransaction.getThreadLocalTransaction().abort();
        }
    }
}

