/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.isolation;

import java.util.concurrent.atomic.AtomicLong;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.integrationtests.Ref;

public class NoUnwantedReadConsistencyStressTest {
    public long readCount = 500000L;
    public int readThreadCount = 10;
    public int refCount = 100;
    public volatile boolean finished = false;
    public final AtomicLong inconsistenciesCounter = new AtomicLong();

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.inconsistenciesCounter.set(0L);
    }

    @Test
    public void test() {
        Ref[] refs = new Ref[this.refCount];
        for (int k = 0; k < refs.length; ++k) {
            refs[k] = new Ref();
        }
        TestThread[] threads = new ReadThread[this.readThreadCount];
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new ReadThread(refs, k);
        }
        TestUtils.startAll((TestThread[])threads);
        while (!this.finished) {
            for (Ref ref : refs) {
                if (!TestUtils.randomOneOf((int)10)) continue;
                TestUtils.sleepRandomUs((int)10);
                ref.inc();
            }
        }
        TestUtils.joinAll((TestThread[])threads);
        System.out.println("number of readinconsistencies: " + this.inconsistenciesCounter.get());
        Assert.assertTrue((this.inconsistenciesCounter.get() > 0L ? 1 : 0) != 0);
    }

    class ReadThread
    extends TestThread {
        private Ref[] refs;

        public ReadThread(Ref[] refs, int id) {
            super("ReadThread-" + id);
            this.refs = refs;
        }

        public void doRun() throws Exception {
            int readInconsistencies = 0;
            int k = 0;
            while ((long)k < NoUnwantedReadConsistencyStressTest.this.readCount) {
                readInconsistencies += this.doread();
                if (k % 10000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                ++k;
            }
            NoUnwantedReadConsistencyStressTest.this.finished = true;
            NoUnwantedReadConsistencyStressTest.this.inconsistenciesCounter.addAndGet(readInconsistencies);
        }

        private int doread() {
            int[] values = new int[this.refs.length];
            for (int k = 0; k < this.refs.length; ++k) {
                values[k] = this.refs[k].get();
            }
            TestUtils.sleepRandomUs((int)10);
            int inconsistencies = 0;
            for (int k = 0; k < this.refs.length; ++k) {
                if (values[k] == this.refs[k].get()) continue;
                ++inconsistencies;
            }
            return inconsistencies;
        }
    }
}

