/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.isolation;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class NonRepeatableReadStressTest {
    private TransactionalInteger ref;
    private int readCount = 10000;
    private int readThreadCount = 5;
    private int modifyThreadCount = 2;
    private volatile boolean readersFinished;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.ref = new TransactionalInteger(0);
        this.readersFinished = false;
    }

    @Test
    public void test() {
        TestThread[] modifyThreads = new ModifyThread[this.modifyThreadCount];
        for (int k = 0; k < this.modifyThreadCount; ++k) {
            modifyThreads[k] = new ModifyThread(k);
        }
        TestThread[] readerThread = new ReadThread[this.readThreadCount];
        for (int k = 0; k < this.readThreadCount; ++k) {
            readerThread[k] = new ReadThread(k);
        }
        TestUtils.startAll((TestThread[])modifyThreads);
        TestUtils.startAll((TestThread[])readerThread);
        TestUtils.joinAll((TestThread[])modifyThreads);
        TestUtils.joinAll((TestThread[])readerThread);
    }

    class ReadThread
    extends TestThread {
        public ReadThread(int id) {
            super("ReadThread-" + id);
        }

        public void doRun() {
            for (int k = 0; k < NonRepeatableReadStressTest.this.readCount; ++k) {
                if (k % 1000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                if (k % 2 == 0) {
                    this.readUsingUpdateTransaction();
                    continue;
                }
                this.readUsingReadonlyTransaction();
            }
            NonRepeatableReadStressTest.this.readersFinished = true;
        }

        @TransactionalMethod(readonly=true)
        private void readUsingReadonlyTransaction() {
            this.read();
        }

        @TransactionalMethod(readonly=false)
        private void readUsingUpdateTransaction() {
            this.read();
        }

        private void read() {
            int firstTime = NonRepeatableReadStressTest.this.ref.get();
            TestUtils.sleepRandomMs((int)2);
            int secondTime = NonRepeatableReadStressTest.this.ref.get();
            Assert.assertEquals((long)firstTime, (long)secondTime);
        }
    }

    class ModifyThread
    extends TestThread {
        public ModifyThread(int id) {
            super("ModifyThread-" + id);
        }

        public void doRun() {
            int k = 0;
            while (!NonRepeatableReadStressTest.this.readersFinished) {
                if (k % 1000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                ++k;
                NonRepeatableReadStressTest.this.ref.inc();
                TestUtils.sleepRandomMs((int)5);
            }
        }
    }
}

