/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.isolation;

import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.collections.TransactionalArrayList;
import org.multiverse.transactional.collections.TransactionalLinkedList;

public class PhantomReadStressTest {
    private int readCount = 1000;
    private int readThreadCount = 10;
    private int modifyThreadCount = 2;
    private List table;
    private volatile boolean readersFinished;

    @Before
    public void setUp() {
        this.readersFinished = false;
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void testStrictTransactionalLinkedList() {
        this.test((List)new TransactionalLinkedList(1000000, true));
    }

    @Test
    public void testRelaxedTransactionalLinkedList() {
        this.test((List)new TransactionalLinkedList(1000000, false));
    }

    @Test
    public void testTransactionalArrayList() {
        this.test((List)new TransactionalArrayList());
    }

    public void test(List table) {
        this.table = table;
        TestThread[] modifyThreads = new ModifyThread[this.modifyThreadCount];
        for (int k = 0; k < this.modifyThreadCount; ++k) {
            modifyThreads[k] = new ModifyThread(k);
        }
        TestThread[] readerThread = new ReadThread[this.readThreadCount];
        for (int k = 0; k < this.readThreadCount; ++k) {
            readerThread[k] = new ReadThread(k);
        }
        TestUtils.startAll((TestThread[])modifyThreads);
        TestUtils.startAll((TestThread[])readerThread);
        TestUtils.joinAll((TestThread[])modifyThreads);
        TestUtils.joinAll((TestThread[])readerThread);
    }

    public class ReadThread
    extends TestThread {
        public ReadThread(int id) {
            super("ReadThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < PhantomReadStressTest.this.readCount; ++k) {
                boolean readonly;
                boolean bl = readonly = k % 2 == 0;
                if (readonly) {
                    this.readWithReadonlyTransaction();
                } else {
                    this.readWithUpdateTransaction();
                }
                if (k % 500 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
            PhantomReadStressTest.this.readersFinished = true;
        }

        @TransactionalMethod(readonly=false)
        public void readWithUpdateTransaction() {
            this.readLogic();
        }

        @TransactionalMethod(readonly=true)
        private void readWithReadonlyTransaction() {
            this.readLogic();
        }

        private void readLogic() {
            int sizeT1 = PhantomReadStressTest.this.table.size();
            TestUtils.sleepRandomMs((int)10);
            int sizeT2 = PhantomReadStressTest.this.table.size();
            Assert.assertEquals((long)sizeT1, (long)sizeT2);
        }
    }

    class ModifyThread
    extends TestThread {
        public ModifyThread(int id) {
            super("ModifyThread-" + id);
        }

        public void doRun() {
            int k = 0;
            while (!PhantomReadStressTest.this.readersFinished) {
                this.doLogic();
                if (++k % 500 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
        }

        private void doLogic() {
            PhantomReadStressTest.this.table.add("foo");
            TestUtils.sleepRandomMs((int)10);
            PhantomReadStressTest.this.table.add("foo");
        }
    }
}

