/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.liveness;

import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class DeadlockStressTest {
    private int txObjectCount = 100;
    private int threadCount = 10;
    private int transactionCountPerThread = 1000000;
    private TransactionalInteger[] refs;
    private ChangeThread[] threads;

    @Before
    public void setUp() {
        int k;
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.refs = new TransactionalInteger[this.txObjectCount];
        for (k = 0; k < this.txObjectCount; ++k) {
            this.refs[k] = new TransactionalInteger();
        }
        this.threads = new ChangeThread[this.threadCount];
        for (k = 0; k < this.threadCount; ++k) {
            this.threads[k] = new ChangeThread(k);
        }
    }

    @Test
    public void test() {
        TestUtils.startAll((TestThread[])this.threads);
        TestUtils.joinAll((TestThread[])this.threads);
    }

    public class ChangeThread
    extends TestThread {
        public ChangeThread(int id) {
            super("ChangeThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < DeadlockStressTest.this.transactionCountPerThread; ++k) {
                if (k % 100000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                this.transaction();
            }
        }

        @TransactionalMethod
        public void transaction() {
            for (int k = 0; k < DeadlockStressTest.this.refs.length; ++k) {
                if (TestUtils.randomInt((int)10) != 5) continue;
                DeadlockStressTest.this.refs[k].inc();
            }
        }
    }
}

