/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.liveness;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class NormalTransactionWontDeadlockStressTest {
    private int threadCount = 20;
    private int resourceCount = 10;
    private int transactionCount = 200;
    private TransactionalInteger[] refs;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.refs = new TransactionalInteger[this.resourceCount];
        for (int k = 0; k < this.refs.length; ++k) {
            this.refs[k] = new TransactionalInteger();
        }
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void noReadTracking() {
        TestThread[] threads = this.createThreads();
        TestUtils.startAll((TestThread[])threads);
        TestUtils.joinAll((TestThread[])threads);
    }

    public ModifyThread[] createThreads() {
        ModifyThread[] threads = new ModifyThread[this.threadCount];
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new ModifyThread(k);
        }
        return threads;
    }

    public class ModifyThread
    extends TestThread {
        public ModifyThread(int id) {
            super("ModifyThread-" + id);
        }

        public void doRun() {
            for (int k = 0; k < NormalTransactionWontDeadlockStressTest.this.transactionCount; ++k) {
                this.doit();
                if (k % 25 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
        }

        @TransactionalMethod
        private void doit() {
            TransactionalInteger value1 = NormalTransactionWontDeadlockStressTest.this.refs[TestUtils.randomInt((int)(NormalTransactionWontDeadlockStressTest.this.refs.length - 1))];
            value1.inc();
            TestUtils.sleepMs((long)25L);
            TransactionalInteger value2 = NormalTransactionWontDeadlockStressTest.this.refs[TestUtils.randomInt((int)(NormalTransactionWontDeadlockStressTest.this.refs.length - 1))];
            value2.inc();
        }
    }
}

