/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.notification;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.integrationtests.Ref;

public class HandoverRingLongTest {
    private int handoverCount = 500000;
    private int threadCount = 10;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        Ref[] refs = new Ref[this.threadCount];
        for (int k = 0; k < refs.length; ++k) {
            refs[k] = new Ref();
        }
        TestThread[] threads = new HandoverThread[this.threadCount];
        for (int k = 0; k < refs.length; ++k) {
            Ref left = refs[k];
            Ref right = k == refs.length - 1 ? refs[0] : refs[k + 1];
            threads[k] = new HandoverThread(k, left, right);
        }
        TestUtils.startAll((TestThread[])threads);
        refs[0].set(1);
        TestUtils.joinAll((TestThread[])threads);
        for (TestThread t : threads) {
            Assert.assertEquals((long)this.handoverCount, (long)((HandoverThread)t).handovers);
        }
    }

    class HandoverThread
    extends TestThread {
        private final Ref left;
        private final Ref right;
        private int handovers;
        private final int id;

        HandoverThread(int id, Ref left, Ref right) {
            super("HandoverThread-" + id);
            this.left = left;
            this.right = right;
            this.id = id;
        }

        public void doRun() throws Exception {
            for (int k = 0; k < HandoverRingLongTest.this.handoverCount; ++k) {
                this.left.await(1);
                this.left.set(0);
                this.right.set(1);
                ++this.handovers;
                if (k % 50000 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
        }
    }
}

