/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.notification;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.RetryTimeoutException;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class NotificationTimeoutTest {
    private TransactionalInteger ref;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.ref = new TransactionalInteger();
    }

    @Test
    public void whenTimedOut() {
        try {
            this.await(1);
            Assert.fail();
        }
        catch (RetryTimeoutException retryTimeoutException) {
            // empty catch block
        }
    }

    @Test
    public void whenSomeWaitingNeeded() {
        SetThread t = new SetThread(1, 1);
        t.start();
        this.await(1);
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
    }

    @Test
    public void whenSpuriousWakeupsAndTimeout() {
        SetThread t = new SetThread(2, 1);
        t.start();
        try {
            this.await(1);
            Assert.fail();
        }
        catch (RetryTimeoutException retryTimeoutException) {
            // empty catch block
        }
        TestUtils.joinAll((TestThread[])new TestThread[]{t});
    }

    @Test
    public void whenSpuriousWakeups() {
        SetThread t1 = new SetThread(2, 1);
        t1.start();
        SetThread t2 = new SetThread(1, 2);
        t2.start();
        this.await(1);
        TestUtils.joinAll((TestThread[])new TestThread[]{t1, t2});
    }

    @Test
    public void whenNoRetryNeeded() {
        this.await(0);
    }

    @TransactionalMethod(timeout=3L)
    public void await(int value) {
        this.ref.await(value);
    }

    class SetThread
    extends TestThread {
        private final int value;
        private final int delayMs;

        SetThread(int value, int delayMs) {
            super("SetThread");
            this.value = value;
            this.delayMs = delayMs;
        }

        public void doRun() throws Exception {
            TestUtils.sleepMs((long)this.delayMs);
            NotificationTimeoutTest.this.ref.set(this.value);
        }
    }
}

