/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.notification;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.integrationtests.Ref;

public class PingPongStressTest {
    private int pingPongCount = 1000000;
    private int threadCount = 2;
    private Ref intValue;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.intValue = new Ref(0);
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        TestThread[] threads = this.createThreads();
        TestUtils.startAll((TestThread[])threads);
        TestUtils.joinAll((TestThread[])threads);
        Assert.assertEquals((long)(this.pingPongCount * this.threadCount), (long)this.intValue.get());
    }

    private PingPongThread[] createThreads() {
        PingPongThread[] threads = new PingPongThread[this.threadCount];
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new PingPongThread(k);
        }
        return threads;
    }

    private class PingPongThread
    extends TestThread {
        private int id;

        public PingPongThread(int id) {
            super("PingPongThread-" + id);
            this.id = id;
        }

        public void doRun() {
            int expected = this.id;
            for (int k = 0; k < PingPongStressTest.this.pingPongCount; ++k) {
                if (k % 100000 == 0) {
                    System.out.println(this.getName() + " " + k);
                }
                PingPongStressTest.this.intValue.await(expected);
                PingPongStressTest.this.intValue.inc();
                expected += PingPongStressTest.this.threadCount;
            }
        }
    }
}

