/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.notification;

import org.junit.Assert;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class RetryInterruptibleTest {
    private TransactionalInteger ref;

    @Test
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() throws InterruptedException {
        this.ref = new TransactionalInteger(0);
        AwaitThread t = new AwaitThread();
        t.start();
        TestUtils.sleepMs((long)200L);
        TestUtils.assertAlive((Thread[])new Thread[]{t});
        t.interrupt();
        t.join();
        Assert.assertTrue((boolean)t.wasInterrupted);
    }

    class AwaitThread
    extends Thread {
        private boolean wasInterrupted;

        AwaitThread() {
        }

        @Override
        public void run() {
            try {
                this.await();
            }
            catch (InterruptedException e) {
                this.wasInterrupted = true;
            }
        }

        @TransactionalMethod(trackReads=true, interruptible=true)
        public void await() throws InterruptedException {
            RetryInterruptibleTest.this.ref.await(1);
        }
    }
}

