/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.ReadonlyException;
import org.multiverse.integrationtests.Ref;

public class ReadonlyTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenReadonly_thenUpdateFails() {
        Ref ref = new Ref(0);
        try {
            this.updateInReadonlyMethod(ref, 10);
            Assert.fail();
        }
        catch (ReadonlyException readonlyException) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)ref.get());
    }

    @TransactionalMethod(readonly=true)
    public void updateInReadonlyMethod(Ref ref, int newValue) {
        ref.set(newValue);
    }

    @Test
    public void whenReadonly_thenCreationOfNewTransactionalObjectNotFails() {
        try {
            this.readonly_createNewTransactionObject(10);
            Assert.fail();
        }
        catch (ReadonlyException readonlyException) {
            // empty catch block
        }
    }

    @TransactionalMethod(readonly=true)
    public Ref readonly_createNewTransactionObject(int value) {
        return new Ref(value);
    }

    @Test
    public void whenReadonly_thenCreationOfNonTransactionalObjectSucceeds() {
        Integer ref = this.readonly_createNormalObject(100);
        Assert.assertNotNull((Object)ref);
        Assert.assertEquals((long)100L, (long)ref.intValue());
    }

    @TransactionalMethod(readonly=true)
    public Integer readonly_createNormalObject(int value) {
        return new Integer(value);
    }

    @Test
    public void whenReadonly_thenReadAllowed() {
        Ref ref = new Ref(10);
        int result = this.readInReadonlyMethod(ref);
        Assert.assertEquals((long)10L, (long)result);
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @TransactionalMethod(readonly=true)
    public int readInReadonlyMethod(Ref ref) {
        return ref.get();
    }

    @Test
    public void whenUpdate_thenCreationOfNewTransactionalObjectsSucceeds() {
        Ref ref = this.update_createNewTransactionObject(100);
        Assert.assertNotNull((Object)ref);
        Assert.assertEquals((long)100L, (long)ref.get());
    }

    @TransactionalMethod(readonly=false)
    public Ref update_createNewTransactionObject(int value) {
        return new Ref(value);
    }

    @Test
    public void whenUpdate_thenCreationOfNonTransactionalObjectSucceeds() {
        Integer ref = this.update_createNormalObject(100);
        Assert.assertNotNull((Object)ref);
        Assert.assertEquals((long)100L, (long)ref.intValue());
    }

    @TransactionalMethod(readonly=false)
    public Integer update_createNormalObject(int value) {
        return new Integer(value);
    }

    @Test
    public void whenUpdate_thenReadSucceeds() {
        Ref ref = new Ref(10);
        int result = this.readInUpdateMethod(ref);
        Assert.assertEquals((long)10L, (long)result);
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @TransactionalMethod(readonly=false)
    public int readInUpdateMethod(Ref ref) {
        return ref.get();
    }

    @Test
    public void whenUpdate_thenUpdateSucceeds() {
        Ref ref = new Ref(0);
        this.updateInUpdateMethod(ref, 10);
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @TransactionalMethod(readonly=false)
    public void updateInUpdateMethod(Ref ref, int newValue) {
        ref.set(newValue);
    }
}

