/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.integrationtests.stability;

import java.util.LinkedList;
import java.util.Random;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.templates.TransactionTemplate;
import org.multiverse.transactional.DefaultTransactionalReference;

public class CycleHandlingStressTest {
    private Stm stm;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stm = GlobalStmInstance.getGlobalStmInstance();
    }

    public Transaction startUpdateTransaction() {
        Transaction t = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        return t;
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void directCycle() {
        Transaction t = this.startUpdateTransaction();
        SingleLinkedNode node = new SingleLinkedNode();
        node.setNext(node);
        t.commit();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        Assert.assertSame((Object)node, (Object)node.getNext());
    }

    @Test
    public void shortIndirectCycle() {
        Transaction t = this.startUpdateTransaction();
        SingleLinkedNode node1 = new SingleLinkedNode();
        SingleLinkedNode node2 = new SingleLinkedNode();
        node1.setNext(node2);
        node2.setNext(node1);
        t.commit();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        Assert.assertSame((Object)node1.getNext(), (Object)node2);
        Assert.assertSame((Object)node2.getNext(), (Object)node1);
    }

    @Test
    public void longIndirectCycleCommitsWithoutFailure() {
        Transaction t = this.startUpdateTransaction();
        SingleLinkedNode original = this.createLongChain(100000);
        t.commit();
    }

    private SingleLinkedNode createLongChain(int depth) {
        SingleLinkedNode first;
        SingleLinkedNode current = first = new SingleLinkedNode();
        for (int k = 0; k < depth; ++k) {
            SingleLinkedNode newHolder = new SingleLinkedNode();
            current.setNext(newHolder);
            current = newHolder;
        }
        current.setNext(first);
        return first;
    }

    @Test
    public void complexObjectGraphWithLoadsOfCycles() {
        int nodeCount = 100000;
        long oldVersion = this.stm.getVersion();
        new TransactionTemplate(){

            public Object execute(Transaction t) throws Exception {
                ComplexNode node = CycleHandlingStressTest.this.createComplexGraphWithLoadsOfCycles(100000);
                return null;
            }
        }.execute();
        Assert.assertEquals((long)oldVersion, (long)this.stm.getVersion());
    }

    @Test
    public void anotherComplexObjectGraphWithLoadsOfCycles() {
        int nodeCount = 100000;
        long oldVersion = this.stm.getVersion();
        new TransactionTemplate(this.stm.getTransactionFactoryBuilder().setReadonly(false).build()){

            public Object execute(Transaction t) throws Exception {
                ComplexNode node = CycleHandlingStressTest.this.createAnotherComplexGraphWithLoadsOfCycles(100000);
                return null;
            }
        }.execute();
        Assert.assertEquals((long)oldVersion, (long)this.stm.getVersion());
    }

    private ComplexNode createComplexGraphWithLoadsOfCycles(int nodeCount) {
        if (nodeCount <= 0) {
            throw new IllegalArgumentException("nodeCount parameter should be > 0.");
        }
        Random rng = new Random();
        double referenceProbability = 0.1;
        double nullProbability = 0.2;
        int maxReferenceListSize = 12;
        LinkedList<ComplexNode> workList = new LinkedList<ComplexNode>();
        LinkedList<ComplexNode> backreferences = new LinkedList<ComplexNode>();
        ComplexNode root = new ComplexNode();
        --nodeCount;
        workList.addFirst(root);
        backreferences.addFirst(root);
        while (!workList.isEmpty() && nodeCount > 0) {
            ComplexNode current = (ComplexNode)workList.removeLast();
            ComplexNode[] children = new ComplexNode[3];
            for (int i = 0; i < 3; ++i) {
                double randomVal = rng.nextDouble();
                if (randomVal <= 0.2) {
                    children[i] = null;
                    continue;
                }
                if (randomVal <= 0.30000000000000004 || nodeCount <= 0) {
                    children[i] = (ComplexNode)backreferences.peekLast();
                    continue;
                }
                children[i] = new ComplexNode();
                workList.push(children[i]);
                backreferences.addFirst(children[i]);
                --nodeCount;
                if (backreferences.size() <= 12) continue;
                backreferences.removeLast();
            }
            current.setEdge1(children[0]);
            current.setEdge2(children[1]);
            current.setEdge3(children[2]);
        }
        if (nodeCount > 0) {
            ComplexNode rightMost = root;
            while (rightMost.getEdge3() != null) {
                rightMost = rightMost.getEdge3();
            }
            ComplexNode parent = rightMost;
            while (nodeCount > 0) {
                ComplexNode child = new ComplexNode();
                --nodeCount;
                parent.setEdge3(child);
                parent = child;
            }
        }
        return root;
    }

    private ComplexNode createAnotherComplexGraphWithLoadsOfCycles(int nodeCount) {
        ComplexNode node;
        int k;
        ComplexNode root;
        if (nodeCount <= 0) {
            throw new IllegalArgumentException("nodeCount parameter should be > 0.");
        }
        Random rng = new Random();
        ComplexNode[] nodes = new ComplexNode[nodeCount];
        nodes[0] = root = new ComplexNode();
        ComplexNode current = root;
        for (k = 1; k < nodeCount; ++k) {
            ComplexNode newNode;
            nodes[k] = newNode = new ComplexNode();
            current.setEdge2(newNode);
            current = newNode;
        }
        for (k = 0; k < nodeCount; ++k) {
            node = nodes[k];
            int edge1Index = (int)Math.round(Math.floor(rng.nextFloat() * (float)nodeCount));
            node.setEdge1(nodes[edge1Index]);
            int edge3Index = (int)Math.round(Math.floor(rng.nextFloat() * (float)nodeCount));
            node.setEdge3(nodes[edge3Index]);
        }
        for (k = 0; k < nodeCount; k += 10) {
            node = nodes[k];
            node.setEdge1(node);
            node.setEdge3(null);
        }
        return root;
    }

    static class ComplexNode {
        final DefaultTransactionalReference<ComplexNode> edge1Ref = new DefaultTransactionalReference();
        final DefaultTransactionalReference<ComplexNode> edge2Ref = new DefaultTransactionalReference();
        final DefaultTransactionalReference<ComplexNode> edge3Ref = new DefaultTransactionalReference();

        ComplexNode() {
        }

        @TransactionalMethod
        public ComplexNode getEdge1() {
            return (ComplexNode)this.edge1Ref.get();
        }

        @TransactionalMethod
        public void setEdge1(ComplexNode edge1) {
            this.edge1Ref.set((Object)edge1);
        }

        @TransactionalMethod
        public ComplexNode getEdge2() {
            return (ComplexNode)this.edge2Ref.get();
        }

        @TransactionalMethod
        public void setEdge2(ComplexNode edge2) {
            this.edge2Ref.set((Object)edge2);
        }

        @TransactionalMethod
        public ComplexNode getEdge3() {
            return (ComplexNode)this.edge3Ref.get();
        }

        @TransactionalMethod
        public void setEdge3(ComplexNode edge3) {
            this.edge3Ref.set((Object)edge3);
        }
    }

    @TransactionalObject
    public static class SingleLinkedNode {
        private SingleLinkedNode next;

        public SingleLinkedNode getNext() {
            return this.next;
        }

        public void setNext(SingleLinkedNode next) {
            this.next = next;
        }
    }
}

