/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.NoRetryPossibleException;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTestUtils;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class RegisterRetryListenerTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = new AlphaStm();
    }

    public Transaction startUpdateTransaction() {
        AlphaTransaction t = AlphaTestUtils.startTrackingUpdateTransaction(this.stm);
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        return t;
    }

    @Test
    public void testNothingRead() {
        Transaction tx = this.startUpdateTransaction();
        long startVersion = this.stm.getVersion();
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException ex) {
            // empty catch block
        }
        Assert.assertEquals((long)startVersion, (long)this.stm.getVersion());
        Assert.assertFalse((boolean)latch.isOpen());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void testOnlyNewOnesAttached() {
        Transaction tx = this.startUpdateTransaction();
        TransactionalInteger ref = new TransactionalInteger(0);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException ex) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void test() {
        Transaction tx1 = this.startUpdateTransaction();
        TransactionalInteger ref = new TransactionalInteger(10);
        tx1.commit();
        Transaction tx2 = this.startUpdateTransaction();
        int result = ref.get();
        CheapLatch latch = new CheapLatch();
        tx2.registerRetryLatch((Latch)latch);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx2});
        Assert.assertFalse((boolean)latch.isOpen());
    }
}

