/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import java.io.FileNotFoundException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class TransactionalMethod_ExceptionsTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void checkedExceptionIsPropagated() {
        FileNotFoundException ex = new FileNotFoundException();
        CheckedExceptionIsPropagated r = new CheckedExceptionIsPropagated();
        r.exception = ex;
        long version = this.stm.getVersion();
        try {
            r.doIt();
            Assert.fail();
        }
        catch (Exception found) {
            Assert.assertSame((Object)ex, (Object)found);
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)0L, (long)r.ref.get());
    }

    @Test
    public void runtimeExceptionIsPropagated() {
        IllegalArgumentException ex = new IllegalArgumentException();
        RuntimeExceptionIsPropagated r = new RuntimeExceptionIsPropagated();
        r.exception = ex;
        long version = this.stm.getVersion();
        try {
            r.doIt();
            Assert.fail();
        }
        catch (RuntimeException found) {
            Assert.assertSame((Object)ex, (Object)found);
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)0L, (long)r.ref.get());
    }

    public static class RuntimeExceptionIsPropagated {
        RuntimeException exception;
        TransactionalInteger ref = new TransactionalInteger(0);

        @TransactionalMethod
        public void doIt() {
            this.ref.inc();
            throw this.exception;
        }
    }

    public static class CheckedExceptionIsPropagated {
        Exception exception;
        TransactionalInteger ref = new TransactionalInteger(0);

        @TransactionalMethod
        public void doIt() throws Exception {
            this.ref.inc();
            throw this.exception;
        }
    }
}

