/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.templates.TransactionTemplate;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class TransactionalMethod_MiscTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
    }

    @After
    public void tearDown() {
    }

    public static void assertTransactionWorking() {
        TestUtils.assertIsActive((Transaction[])new Transaction[]{ThreadLocalTransaction.getThreadLocalTransaction()});
    }

    @Test
    public void clashingAtomicMethodNames() {
        ClashingAtomicMethodNames clashingMethodNames = new ClashingAtomicMethodNames();
        clashingMethodNames.doIt(1);
        clashingMethodNames.doIt(true);
    }

    @Test
    public void atomicMethodOnAtomicObjectDoesntCauseHarm() {
        AtomicMethodOnAtomicObject o = new AtomicMethodOnAtomicObject();
        long version = this.stm.getVersion();
        o.inc();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)11L, (long)o.getValue());
    }

    @Test
    public void atomicObjectCreatedInAtomicMethod() {
        AtomicObjectCreated o = new AtomicObjectCreated();
        long version = this.stm.getVersion();
        o.doit(100);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)100L, (long)o.getRef().get());
    }

    @Test
    public void atomicMethodWithAtomicTemplateDoesntCauseHarm() {
        ObjectWithAtomicMethodAndAtomicTemplate o = new ObjectWithAtomicMethodAndAtomicTemplate();
        long version = this.stm.getVersion();
        o.inc();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)o.getValue());
    }

    @TransactionalObject
    public static class ObjectWithAtomicMethodAndAtomicTemplate {
        public int value = 0;

        @TransactionalMethod
        public void inc() {
            new TransactionTemplate(){

                public Object execute(Transaction t) throws Exception {
                    ++ObjectWithAtomicMethodAndAtomicTemplate.this.value;
                    return null;
                }
            }.execute();
        }

        public int getValue() {
            return this.value;
        }
    }

    public static class AtomicObjectCreated {
        private TransactionalInteger ref;

        @TransactionalMethod
        public void doit(int v) {
            this.ref = new TransactionalInteger(v);
        }

        public TransactionalInteger getRef() {
            return this.ref;
        }
    }

    @TransactionalObject
    public static class AtomicMethodOnAtomicObject {
        private int value = 10;

        @TransactionalMethod
        public void inc() {
            ++this.value;
        }

        public int getValue() {
            return this.value;
        }
    }

    public class ClashingAtomicMethodNames {
        @TransactionalMethod
        public void doIt(boolean b) {
            TransactionalMethod_MiscTest.assertTransactionWorking();
        }

        @TransactionalMethod
        public void doIt(int i) {
            TransactionalMethod_MiscTest.assertTransactionWorking();
        }
    }
}

