/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;

public class TransactionalMethod_ReturnTypesTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
    }

    @After
    public void tearDown() {
    }

    public static void assertTransactionWorking() {
        TestUtils.assertIsActive((Transaction[])new Transaction[]{ThreadLocalTransaction.getThreadLocalTransaction()});
    }

    @Test
    public void voidReturningMethod() {
        VoidReturningMethod m = new VoidReturningMethod();
        m.doIt();
    }

    @Test
    public void objectReturningMethod() {
        String s = new ObjectReturningMethod().doIt();
        Assert.assertEquals((Object)"foo", (Object)s);
    }

    @Test
    public void integerReturningMethod() {
        Integer result = new IntegerReturningMethod().doIt();
        Assert.assertEquals((Object)new Integer(10), (Object)result);
    }

    @Test
    public void booleanReturningMethod() {
        BooleanReturningMethod m = new BooleanReturningMethod();
        boolean result = m.doIt();
        Assert.assertTrue((boolean)result);
    }

    @Test
    public void byteReturningMethod() {
        ByteReturningMethod m = new ByteReturningMethod();
        byte result = m.doIt();
        Assert.assertEquals((long)11L, (long)result);
    }

    @Test
    public void shortReturningMethod() {
        ShortReturningMethod m = new ShortReturningMethod();
        short result = m.doIt();
        Assert.assertEquals((long)11L, (long)result);
    }

    @Test
    public void charReturningMethod() {
        CharReturningMethod m = new CharReturningMethod();
        char result = m.doIt();
        Assert.assertEquals((long)112L, (long)result);
    }

    @Test
    public void intReturningMethod() {
        IntReturningMethod m = new IntReturningMethod();
        int result = m.doIt();
        Assert.assertEquals((long)111L, (long)result);
    }

    @Test
    public void floatReturningMehod() {
        FloatReturningMethod m = new FloatReturningMethod();
        float result = m.doIt();
        Assert.assertEquals((double)11.4f, (double)result, (double)1.0E-4);
    }

    @Test
    public void longReturningMethod() {
        LongReturningMethod m = new LongReturningMethod();
        long result = m.doIt();
        Assert.assertEquals((long)111L, (long)result);
    }

    @Test
    public void doubleReturningMethod() {
        DoubleReturningMethod m = new DoubleReturningMethod();
        double result = m.doIt();
        Assert.assertEquals((double)11.4, (double)result, (double)1.0E-4);
    }

    @Test
    public void primitiveArrayReturningMethod() {
        PrimitiveArrayReturningMethod m = new PrimitiveArrayReturningMethod();
        boolean[] result = m.doIt();
        Assert.assertEquals((long)2L, (long)result.length);
        Assert.assertTrue((boolean)result[0]);
        Assert.assertFalse((boolean)result[1]);
    }

    @Test
    public void objectArrayReturningMethod() {
        String[] array = new String[]{"foo", "bar"};
        ObjectArrayReturningMethod m = new ObjectArrayReturningMethod();
        m.result = array;
        Object[] result = m.doIt();
        Assert.assertSame((Object)array, (Object)result);
    }

    public static class ObjectArrayReturningMethod {
        Object[] result;

        @TransactionalMethod
        public Object[] doIt() {
            TransactionalMethod_ReturnTypesTest.assertTransactionWorking();
            return this.result;
        }
    }

    public static class PrimitiveArrayReturningMethod {
        @TransactionalMethod
        public boolean[] doIt() {
            TransactionalMethod_ReturnTypesTest.assertTransactionWorking();
            return new boolean[]{true, false};
        }
    }

    public static class DoubleReturningMethod {
        @TransactionalMethod
        public double doIt() {
            TransactionalMethod_ReturnTypesTest.assertTransactionWorking();
            return 11.4;
        }
    }

    public static class LongReturningMethod {
        @TransactionalMethod
        public long doIt() {
            TransactionalMethod_ReturnTypesTest.assertTransactionWorking();
            return 111L;
        }
    }

    public static class FloatReturningMethod {
        @TransactionalMethod
        public float doIt() {
            TransactionalMethod_ReturnTypesTest.assertTransactionWorking();
            return 11.4f;
        }
    }

    public static class IntReturningMethod {
        @TransactionalMethod
        public int doIt() {
            TransactionalMethod_ReturnTypesTest.assertTransactionWorking();
            return 111;
        }
    }

    public static class CharReturningMethod {
        @TransactionalMethod
        public char doIt() {
            TransactionalMethod_ReturnTypesTest.assertTransactionWorking();
            return 'p';
        }
    }

    public static class ShortReturningMethod {
        @TransactionalMethod
        public short doIt() {
            TransactionalMethod_ReturnTypesTest.assertTransactionWorking();
            return 11;
        }
    }

    public static class ByteReturningMethod {
        @TransactionalMethod
        public byte doIt() {
            TransactionalMethod_ReturnTypesTest.assertTransactionWorking();
            return 11;
        }
    }

    public static class BooleanReturningMethod {
        @TransactionalMethod
        public boolean doIt() {
            TransactionalMethod_ReturnTypesTest.assertTransactionWorking();
            return true;
        }
    }

    public class IntegerReturningMethod {
        @TransactionalMethod
        public Integer doIt() {
            TransactionalMethod_ReturnTypesTest.assertTransactionWorking();
            return new Integer(10);
        }
    }

    public class ObjectReturningMethod {
        @TransactionalMethod
        public String doIt() {
            TransactionalMethod_ReturnTypesTest.assertTransactionWorking();
            return "foo";
        }
    }

    public class VoidReturningMethod {
        @TransactionalMethod
        public void doIt() {
            TransactionalMethod_ReturnTypesTest.assertTransactionWorking();
        }
    }

    @TransactionalObject
    static class IntValue {
        private int value;

        IntValue(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

