/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.exceptions.NoTransactionFoundException;
import org.multiverse.stms.alpha.AlphaStm;

public class TransactionalObject_FieldAccessTransformerTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
    }

    @Test
    public void fieldAccessWithoutTransaction() {
        SomeRef someRef = new SomeRef();
        long version = this.stm.getVersion();
        try {
            int x = someRef.x;
            Assert.fail();
        }
        catch (NoTransactionFoundException ignore) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void fieldAccessWithTransaction() {
        SomeRef someRef = new SomeRef();
        long version = this.stm.getVersion();
        int x = this.inc(someRef);
        Assert.assertEquals((long)11L, (long)x);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
    }

    @TransactionalMethod
    public int inc(SomeRef someRef) {
        ++someRef.x;
        return someRef.x;
    }

    @TransactionalObject
    public class SomeRef {
        public int x = 10;
    }
}

