/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.instrumentation.AlphaReflectionUtils;

public class TransactionalObject_NonStaticInnerClassTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
    }

    @Test
    public void nonStaticStructure() {
        Assert.assertFalse((boolean)AlphaReflectionUtils.existsField(NonStaticTxObject.class, "value"));
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalClass(NonStaticTxObject.class));
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalField(NonStaticTxObject.class, "value"));
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalSnapshotClass(NonStaticTxObject.class));
        Assert.assertTrue((boolean)AlphaReflectionUtils.existsTranlocalSnapshotField(NonStaticTxObject.class, "value"));
    }

    @Test
    public void nonStaticTxObjectUsage() {
        long version = this.stm.getVersion();
        NonStaticTxObject innerClass = new NonStaticTxObject(10);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)innerClass.getValue());
    }

    @Test
    public void outerWithInner() {
        long version = this.stm.getVersion();
        Outer outer = new Outer();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)outer.getInner());
        version = this.stm.getVersion();
        outer.newInner(10);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertNotNull((Object)outer.getInner());
        Assert.assertEquals((long)10L, (long)outer.getInner().getValue());
    }

    @TransactionalObject
    static class Outer {
        private Inner inner = null;

        @TransactionalMethod(readonly=true)
        public Inner getInner() {
            return this.inner;
        }

        public void newInner(int value) {
            this.inner = new Inner(value);
        }

        @TransactionalObject
        class Inner {
            private int value;

            Inner(int value) {
                this.value = value;
            }

            @TransactionalMethod(readonly=true)
            public int getValue() {
                return this.value;
            }
        }
    }

    @TransactionalObject
    class NonStaticTxObject {
        int value;

        NonStaticTxObject(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public void setValue(int value) {
            this.value = value;
        }
    }
}

