/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.instrumentation.fieldaccess;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaTransactionalObject;

public class TransactionalObject_SubclassTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
    }

    @Test
    @Ignore
    public void subclassingWithExplicitTxObjectAnnotation() {
        A a = new A();
        B.class.toString();
        B b = new B();
        Assert.assertTrue((boolean)(b instanceof AlphaTransactionalObject));
    }

    @Test
    public void testTxObjectExtendingOtherNonTxObject() {
        long version = this.stm.getVersion();
        Banana banana = new Banana();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)0L, (long)banana.getLength());
    }

    @Test
    public void methodOnTxObject() {
        Banana banana = new Banana();
        long version = this.stm.getVersion();
        banana.setLength(100);
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)100L, (long)banana.getLength());
    }

    @Test
    public void methodOnSuper() {
        Banana banana = new Banana();
        long version = this.stm.getVersion();
        banana.setWeight(100);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)100L, (long)banana.getWeight());
    }

    @Test
    public void constructorThatCallsParametrizedSuper() {
        int weight = 10;
        int length = 20;
        long version = this.stm.getVersion();
        Banana banana = new Banana(weight, length);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)weight, (long)banana.getWeight());
        Assert.assertEquals((long)length, (long)banana.getLength());
    }

    @TransactionalObject
    static class Banana
    extends Fruit {
        private int length;

        Banana() {
            this.length = 0;
        }

        Banana(int length) {
            this.length = length;
        }

        Banana(int weight, int length) {
            super(weight);
            this.length = length;
        }

        public int getLength() {
            return this.length;
        }

        public void setLength(int length) {
            this.length = length;
        }
    }

    static class Fruit {
        private int weight;

        public Fruit() {
            this.weight = 1;
        }

        public Fruit(int weight) {
            this.weight = weight;
        }

        public void setWeight(int weight) {
            this.weight = weight;
        }

        public int getWeight() {
            return this.weight;
        }
    }

    @TransactionalObject
    public static class B
    extends A {
        protected int y;
    }

    @TransactionalObject
    public static class A {
        protected int x;
    }
}

