/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.integrationtests;

import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class AtomicBehaviorStressTest {
    private Stm stm;
    private TransactionalInteger ref;
    private int modifyCount = 500;
    private AtomicInteger modifyCountDown = new AtomicInteger();

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        this.ref = new TransactionalInteger(0);
    }

    @Test
    public void test() {
        this.modifyCountDown.set(this.modifyCount);
        ModifyThread modifyThread = new ModifyThread(0);
        ObserverThread observerThread = new ObserverThread();
        TestUtils.startAll((TestThread[])new TestThread[]{modifyThread, observerThread});
        TestUtils.joinAll((TestThread[])new TestThread[]{modifyThread, observerThread});
    }

    class ObserverThread
    extends TestThread {
        public ObserverThread() {
            super("ObserverThread");
        }

        public void doRun() {
            while (AtomicBehaviorStressTest.this.modifyCountDown.get() > 0) {
                this.doit();
                TestUtils.sleepRandomMs((int)5);
            }
        }

        @TransactionalMethod
        public void doit() {
            if (AtomicBehaviorStressTest.this.ref.get() % 2 != 0) {
                Assert.fail();
            }
        }
    }

    class ModifyThread
    extends TestThread {
        public ModifyThread(int id) {
            super("ModifyThread-" + id);
        }

        public void doRun() {
            while (AtomicBehaviorStressTest.this.modifyCountDown.getAndDecrement() > 0) {
                try {
                    this.doit();
                }
                catch (DeadTransactionException deadTransactionException) {}
            }
        }

        @TransactionalMethod
        public void doit() {
            if (AtomicBehaviorStressTest.this.ref.get() % 2 != 0) {
                Assert.fail();
            }
            AtomicBehaviorStressTest.this.ref.inc();
            TestUtils.sleepRandomMs((int)20);
            if (TestUtils.randomBoolean()) {
                ThreadLocalTransaction.getThreadLocalTransaction().abort();
            } else {
                AtomicBehaviorStressTest.this.ref.inc();
            }
        }
    }
}

