/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.integrationtests;

import java.util.concurrent.TimeUnit;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.Stm;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.api.programmatic.ProgrammaticLong;
import org.multiverse.api.programmatic.ProgrammaticReferenceFactory;
import org.multiverse.stms.alpha.AlphaStm;

public class IndependentScalabilityStressTest {
    private long updateCount = 10000000L;

    @Test
    public void testWithSharedStm() {
        this.test(true);
    }

    @Test
    public void testNoSharedStm() {
        this.test(false);
    }

    private void test(boolean share) {
        int k;
        int processors = Runtime.getRuntime().availableProcessors() / 2;
        AlphaStm stm = null;
        long[] resultsInMs = new long[processors];
        for (k = 0; k < processors; ++k) {
            if (share) {
                if (stm == null) {
                    stm = AlphaStm.createFast();
                }
            } else {
                stm = AlphaStm.createFast();
            }
            resultsInMs[k] = this.test((Stm)stm, k + 1);
        }
        for (k = 0; k < processors; ++k) {
            int processorCount = k + 1;
            double transactionPerSecond = this.updateCount * ((long)processorCount * TimeUnit.SECONDS.toMillis(1L)) / resultsInMs[k];
            System.out.printf("%s processors took %s seconds %s transactions/second  speedupfactor %s\n", processorCount, resultsInMs[k], TestUtils.format((double)transactionPerSecond), TestUtils.format((double)((double)processorCount * 1.0 * (double)resultsInMs[0] / (double)resultsInMs[k])));
        }
    }

    public long test(Stm stm, int threadCount) {
        System.out.println("--------------------------------------------------------");
        System.out.printf("starting with %s threads\n", threadCount);
        System.out.println("--------------------------------------------------------");
        CheapLatch startLatch = new CheapLatch();
        TestThread[] threads = this.createThreads(stm, (Latch)startLatch, threadCount);
        TestUtils.startAll((TestThread[])threads);
        long startMs = System.currentTimeMillis();
        startLatch.open();
        TestUtils.joinAll((TestThread[])threads);
        return System.currentTimeMillis() - startMs;
    }

    public MyThread[] createThreads(Stm stm, Latch startLatch, int threadCount) {
        MyThread[] threads = new MyThread[threadCount];
        ProgrammaticReferenceFactory factory = stm.getProgrammaticReferenceFactoryBuilder().build();
        for (int k = 0; k < threads.length; ++k) {
            threads[k] = new MyThread(k, factory.atomicCreateLong(0L), startLatch);
        }
        return threads;
    }

    class MyThread
    extends TestThread {
        private final ProgrammaticLong ref;
        private final Latch startLatch;

        public MyThread(int id, ProgrammaticLong ref, Latch startLatch) {
            super("Thread-" + id);
            this.startLatch = startLatch;
            this.ref = ref;
        }

        public void doRun() {
            this.startLatch.awaitUninterruptible();
            int k = 0;
            while ((long)k < IndependentScalabilityStressTest.this.updateCount) {
                this.ref.inc(1L);
                if (k % 2000000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                ++k;
            }
        }
    }
}

