/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.integrationtests;

import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class UnsharedDataDoesNotCauseWriteConflictsStressTest {
    private AlphaStm stm;
    private TransactionalInteger[] refs;
    private int threadCount = Runtime.getRuntime().availableProcessors() * 4;
    private int updateCountPerThread = 2000000;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        this.createValues();
        TestThread[] writeThreads = this.createWriteThreads();
        long startNs = System.nanoTime();
        TestUtils.startAll((TestThread[])writeThreads);
        TestUtils.joinAll((TestThread[])writeThreads);
        long periodNs = System.nanoTime() - startNs;
        double transactionPerSecond = (double)(this.updateCountPerThread * this.threadCount) * 1.0 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)periodNs;
        System.out.printf("%s Transaction/second\n", transactionPerSecond);
    }

    private void createValues() {
        this.refs = new TransactionalInteger[this.threadCount];
        for (int k = 0; k < this.threadCount; ++k) {
            this.refs[k] = new TransactionalInteger(0);
        }
    }

    private WriteThread[] createWriteThreads() {
        WriteThread[] result = new WriteThread[this.threadCount];
        for (int k = 0; k < this.threadCount; ++k) {
            result[k] = new WriteThread(k);
        }
        return result;
    }

    private class WriteThread
    extends TestThread {
        private final int id;

        WriteThread(int id) {
            super("TestThread-" + id);
            this.id = id;
        }

        public void doRun() {
            for (int k = 0; k < UnsharedDataDoesNotCauseWriteConflictsStressTest.this.updateCountPerThread; ++k) {
                if (k % 200000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                this.doIt();
            }
        }

        @TransactionalMethod
        private void doIt() {
            TransactionalInteger ref = UnsharedDataDoesNotCauseWriteConflictsStressTest.this.refs[this.id];
            ref.inc();
        }
    }
}

