/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.manualinstrumentation;

import java.util.concurrent.TimeUnit;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.manualinstrumentation.IntStack;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;

public class IntStackPerformanceStressTest {
    private int count = 20000000;
    private AlphaStm stm;
    private TransactionFactory txFactory;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.setThreadLocalTransaction(null);
        this.txFactory = this.stm.getTransactionFactoryBuilder().setReadonly(false).setReadTrackingEnabled(false).build();
    }

    public AlphaTransaction startTransaction() {
        AlphaTransaction t = (AlphaTransaction)this.txFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        return t;
    }

    @Test
    public void test() {
        IntStack stack = new IntStack();
        long startNs = System.nanoTime();
        for (int k = 0; k < this.count; ++k) {
            stack.push(10);
            stack.pop();
            if (k % 500000 != 0) continue;
            System.out.printf("at %s\n", k);
        }
        long periodNs = System.nanoTime() - startNs;
        double transactionPerSecond = (double)this.count * 2.0 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)periodNs;
        System.out.printf("%s Transaction/second\n", transactionPerSecond);
    }

    @Test
    public void testOptimizedTransactionRetrieval() {
        AlphaTransaction t = this.startTransaction();
        IntStack stack = new IntStack();
        t.commit();
        long startNs = System.nanoTime();
        AlphaTransaction pushTx = this.startTransaction();
        AlphaTransaction popTx = this.startTransaction();
        for (int k = 0; k < this.count; ++k) {
            pushTx.restart();
            stack.push(pushTx, 10);
            pushTx.commit();
            popTx.restart();
            stack.pop(popTx);
            popTx.commit();
            if (k % 500000 != 0) continue;
            System.out.printf("at %s\n", k);
        }
        long periodNs = System.nanoTime() - startNs;
        double transactionPerSecond = (double)this.count * 2.0 * (double)TimeUnit.SECONDS.toNanos(1L) / (double)periodNs;
        System.out.printf("%s Transaction/second\n", transactionPerSecond);
    }
}

