/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.manualinstrumentation;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.manualinstrumentation.Ref;

public class RefTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void after() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    public Transaction startTransaction() {
        Transaction t = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).build().start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)t);
        return t;
    }

    @Test
    public void testConstruction_empty() {
        Ref ref = new Ref();
        Assert.assertTrue((boolean)ref.isNull());
    }

    @Test
    public void testConstruction_nonNull() {
        String value = "foo";
        Ref<String> ref = new Ref<String>(value);
        Assert.assertSame((Object)value, (Object)ref.get());
    }

    @Test
    public void testConstruction_null() {
        Ref<Object> ref = new Ref<Object>(null);
        Assert.assertNull(ref.get());
    }

    @Test
    public void clearEmpty() {
        Ref ref = new Ref();
        Assert.assertNull(ref.clear());
    }

    @Test
    public void clearNonEmpty() {
        String value = "foo";
        Ref<String> ref = new Ref<String>(value);
        Assert.assertSame((Object)value, (Object)ref.clear());
    }

    @Test
    public void setNull() {
        Ref ref = new Ref();
        long startVersion = this.stm.getVersion();
        ref.set(null);
        Assert.assertEquals((long)startVersion, (long)this.stm.getVersion());
        Assert.assertNull(ref.get());
    }

    @Test
    public void setNotNull() {
        Ref<String> ref = new Ref<String>();
        long startVersion = this.stm.getVersion();
        String value = "foo";
        ref.set(value);
        Assert.assertEquals((long)(startVersion + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)value, ref.get());
    }

    @Test
    public void testAbaProblemIsNotDetected() {
        String a = "A";
        String b = "B";
        Ref<String> ref = new Ref<String>("A");
        long startVersion = this.stm.getVersion();
        Transaction t = this.startTransaction();
        ref.set("B");
        ref.set("A");
        t.commit();
        Assert.assertEquals((long)startVersion, (long)this.stm.getVersion());
    }
}

