/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.programmatic.ProgrammaticLong;
import org.multiverse.api.programmatic.ProgrammaticReference;
import org.multiverse.api.programmatic.ProgrammaticReferenceFactory;

public class AlphaProgrammaticLongAndReference_integrationStressTest {
    private int threadCount = 10;
    private int transactionCount = 1000000;
    private int queueCapacity = 1000;
    private static final ProgrammaticReferenceFactory refFactory = GlobalStmInstance.getGlobalStmInstance().getProgrammaticReferenceFactoryBuilder().build();
    private Queue<String> queue;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.queue = new Queue();
    }

    @Before
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        TestThread[] producers = new ProducerThread[this.threadCount];
        TestThread[] consumers = new ConsumerThread[this.threadCount];
        for (int k = 0; k < this.threadCount; ++k) {
            producers[k] = new ProducerThread(k);
            consumers[k] = new ConsumerThread(k);
        }
        TestUtils.startAll((TestThread[])producers);
        TestUtils.startAll((TestThread[])consumers);
        TestUtils.joinAll((TestThread[])producers);
        TestUtils.joinAll((TestThread[])consumers);
    }

    @TransactionalObject
    public class Stack<E> {
        final ProgrammaticReference<Node<E>> head = AlphaProgrammaticLongAndReference_integrationStressTest.access$200().atomicCreateReference(null);

        public boolean isEmpty() {
            return this.head.isNull();
        }

        void push(E item) {
            if (item == null) {
                throw new NullPointerException();
            }
            this.head.set(new Node<E>(item, (Node)this.head.get()));
        }

        E pop() {
            if (this.head.isNull()) {
                StmUtils.retry();
            }
            Node h = (Node)this.head.get();
            this.head.set(h.next);
            return h.value;
        }

        class Node<E> {
            final E value;
            final Node<E> next;

            Node(E value, Node<E> next) {
                this.value = value;
                this.next = next;
            }
        }
    }

    @TransactionalObject
    public class Queue<E> {
        private final Stack<E> queuedStack;
        private final Stack<E> popableStack;
        private final ProgrammaticLong size;

        public Queue() {
            this.queuedStack = new Stack();
            this.popableStack = new Stack();
            this.size = refFactory.atomicCreateLong(0L);
        }

        public void push(E item) {
            if (this.size() > AlphaProgrammaticLongAndReference_integrationStressTest.this.queueCapacity) {
                StmUtils.retry();
            }
            this.size.inc(1L);
            this.queuedStack.push(item);
        }

        public E pop() {
            if (this.queuedStack.head.isNull() && this.popableStack.head.isNull()) {
                StmUtils.retry();
            }
            this.size.inc(-1L);
            if (!this.popableStack.isEmpty()) {
                return this.popableStack.pop();
            }
            while (!this.queuedStack.isEmpty()) {
                this.popableStack.push(this.queuedStack.pop());
            }
            return this.popableStack.pop();
        }

        public int size() {
            return (int)this.size.get();
        }
    }

    public class ConsumerThread
    extends TestThread {
        public ConsumerThread(int id) {
            super("ConsumerThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < AlphaProgrammaticLongAndReference_integrationStressTest.this.transactionCount; ++k) {
                this.produce();
                if (k % 100000 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
        }

        @TransactionalMethod
        private void produce() {
            AlphaProgrammaticLongAndReference_integrationStressTest.this.queue.pop();
        }
    }

    public class ProducerThread
    extends TestThread {
        public ProducerThread(int id) {
            super("ProducerThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < AlphaProgrammaticLongAndReference_integrationStressTest.this.transactionCount; ++k) {
                this.produce();
                if (k % 100000 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
        }

        @TransactionalMethod
        private void produce() {
            AlphaProgrammaticLongAndReference_integrationStressTest.this.queue.push("foo");
        }
    }
}

