/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.programmatic.ProgrammaticLong;
import org.multiverse.api.programmatic.ProgrammaticReferenceFactory;
import org.multiverse.stms.alpha.AlphaStm;

public class AlphaProgrammaticLong_atomicBehaviorStressTest {
    private int modifyThreadCount = 10;
    private int transactionCount = 1000000;
    private int refCount = 100;
    private ProgrammaticLong[] refs;
    private AlphaStm stm;
    private ProgrammaticReferenceFactory refFactory;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        this.refFactory = this.stm.getProgrammaticReferenceFactoryBuilder().build();
        this.refs = new ProgrammaticLong[this.refCount];
        for (int k = 0; k < this.refs.length; ++k) {
            this.refs[k] = this.refFactory.atomicCreateLong(0L);
        }
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test_withExplicitAborts() {
        this.test(true);
    }

    @Test
    public void test_withNoExplicitAborts() {
        this.test(false);
    }

    public void test(boolean withAborts) {
        TestThread[] modifyThreads = new ModifyThread[this.modifyThreadCount];
        for (int k = 0; k < this.modifyThreadCount; ++k) {
            modifyThreads[k] = new ModifyThread(k, withAborts);
        }
        TestUtils.startAll((TestThread[])modifyThreads);
        TestUtils.joinAll((TestThread[])modifyThreads);
        Assert.assertEquals((long)this.sumThreads((ModifyThread[])modifyThreads), (long)this.sumRefs());
    }

    public long sumRefs() {
        long result = 0L;
        for (ProgrammaticLong ref : this.refs) {
            result += ref.atomicGet();
        }
        return result;
    }

    public long sumThreads(ModifyThread[] threads) {
        long result = 0L;
        for (ModifyThread thread : threads) {
            result += thread.incCount;
        }
        return result;
    }

    public class ModifyThread
    extends TestThread {
        private final boolean withAborts;
        private long incCount;

        public ModifyThread(int id, boolean withAborts) {
            super("ModifyThread-" + id);
            this.withAborts = withAborts;
        }

        public void doRun() throws Exception {
            for (int k = 0; k < AlphaProgrammaticLong_atomicBehaviorStressTest.this.transactionCount; ++k) {
                boolean abort;
                if (k % 100000 == 0) {
                    System.out.printf("%s is at %s\n", this.getName(), k);
                }
                boolean bl = abort = this.withAborts && k % 2 == 0;
                if (abort) {
                    try {
                        this.incRefsButAbort();
                        Assert.fail();
                    }
                    catch (DeadTransactionException deadTransactionException) {}
                    continue;
                }
                this.incCount += this.incRefs();
            }
        }

        @TransactionalMethod
        private long incRefs() {
            return this.modifyInternal();
        }

        @TransactionalMethod
        private long incRefsButAbort() {
            this.modifyInternal();
            ThreadLocalTransaction.getThreadLocalTransaction().abort();
            return 0L;
        }

        private long modifyInternal() {
            long incCount = 0L;
            for (ProgrammaticLong ref : AlphaProgrammaticLong_atomicBehaviorStressTest.this.refs) {
                if (!TestUtils.randomOneOf((int)10)) continue;
                ref.inc(1L);
                ++incCount;
            }
            return incCount;
        }
    }
}

