/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.StmUtils;
import org.multiverse.api.programmatic.ProgrammaticReferenceFactory;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLong;

public class AlphaProgrammaticLong_blockingStressTest {
    private AlphaStm stm;
    private ProgrammaticReferenceFactory refFactory;
    private AlphaProgrammaticLong ref;
    private int consumerCount = 10;
    private int transactionCount = 10000000;
    private int unprocessedCapacity = 1000;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        this.refFactory = this.stm.getProgrammaticReferenceFactoryBuilder().build();
        this.ref = (AlphaProgrammaticLong)this.refFactory.atomicCreateLong(0L);
    }

    @Test
    public void test() {
        TestThread[] producers = new ProducerThread[this.consumerCount];
        for (int k = 0; k < producers.length; ++k) {
            producers[k] = new ProducerThread(k);
        }
        TestThread[] consumers = new ConsumerThread[this.consumerCount];
        for (int k = 0; k < producers.length; ++k) {
            consumers[k] = new ConsumerThread(k);
        }
        TestUtils.startAll((TestThread[])producers);
        TestUtils.startAll((TestThread[])consumers);
        TestUtils.joinAll((TestThread[])producers);
        TestUtils.joinAll((TestThread[])consumers);
    }

    class ConsumerThread
    extends TestThread {
        public ConsumerThread(int id) {
            super("ConsumerThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < AlphaProgrammaticLong_blockingStressTest.this.transactionCount; ++k) {
                this.consume();
                if (k % 1000000 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
        }

        @TransactionalMethod(readonly=false)
        private void consume() {
            if (AlphaProgrammaticLong_blockingStressTest.this.ref.get() < 0L) {
                throw new RuntimeException();
            }
            if (AlphaProgrammaticLong_blockingStressTest.this.ref.get() == 0L) {
                StmUtils.retry();
            }
            AlphaProgrammaticLong_blockingStressTest.this.ref.inc(-1L);
        }
    }

    class ProducerThread
    extends TestThread {
        public ProducerThread(int id) {
            super("ProducerThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < AlphaProgrammaticLong_blockingStressTest.this.transactionCount; ++k) {
                this.produce();
                if (k % 1000000 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
        }

        @TransactionalMethod(readonly=false)
        private void produce() {
            if (AlphaProgrammaticLong_blockingStressTest.this.ref.get() > (long)AlphaProgrammaticLong_blockingStressTest.this.unprocessedCapacity) {
                throw new RuntimeException();
            }
            if (AlphaProgrammaticLong_blockingStressTest.this.ref.get() >= (long)AlphaProgrammaticLong_blockingStressTest.this.unprocessedCapacity) {
                StmUtils.retry();
            }
            AlphaProgrammaticLong_blockingStressTest.this.ref.inc(1L);
        }
    }
}

