/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLong;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;

public class AlphaProgrammaticLong_getWithTransactionTest {
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenTransactionNull_thenNullPointerException() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 1L);
        long version = this.stm.getVersion();
        try {
            ref.get(null);
            Assert.fail();
        }
        catch (NullPointerException expected) {
            // empty catch block
        }
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)ref.atomicGet());
    }

    @Test
    public void whenSuccess() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 1L);
        Transaction tx = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).build().start();
        long version = this.stm.getVersion();
        long result = ref.get(tx);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)ref.atomicGet());
        Assert.assertEquals((long)1L, (long)result);
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        AlphaTransaction tx = (AlphaTransaction)this.stm.getTransactionFactoryBuilder().build().start();
        tx.abort();
        long version = this.stm.getVersion();
        try {
            ref.get((Transaction)tx);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        AlphaTransaction tx = (AlphaTransaction)this.stm.getTransactionFactoryBuilder().build().start();
        tx.commit();
        long version = this.stm.getVersion();
        try {
            ref.get((Transaction)tx);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)ref.get());
    }

    @Test
    public void whenPrepared_thenPreparedTransactionException() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(this.stm, 10L);
        AlphaTransaction tx = (AlphaTransaction)this.stm.getTransactionFactoryBuilder().build().start();
        tx.prepare();
        long version = this.stm.getVersion();
        try {
            ref.get((Transaction)tx);
            Assert.fail();
        }
        catch (PreparedTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((long)10L, (long)ref.get());
    }
}

