/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.programmatic.ProgrammaticReference;
import org.multiverse.api.programmatic.ProgrammaticReferenceFactory;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticReference;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;

public class AlphaProgrammaticReferenceFactoryTest {
    private AlphaStm stm;
    private ProgrammaticReferenceFactory refFactory;
    private TransactionFactory<AlphaTransaction> txFactory;

    @Before
    public void setUp() {
        this.stm = (AlphaStm)GlobalStmInstance.getGlobalStmInstance();
        this.txFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).setReadonly(false).build();
        this.refFactory = this.stm.getProgrammaticReferenceFactoryBuilder().build();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void makeSureFactoryNotNull() {
        Assert.assertNotNull((Object)this.refFactory);
    }

    @Test
    public void create() {
        ProgrammaticReference ref = this.refFactory.createReference(null);
        TestUtils.assertInstanceOf((Object)ref, AlphaProgrammaticReference.class);
    }

    @Test
    public void createWithTransaction() {
        Transaction tx = this.txFactory.start();
        ProgrammaticReference ref = this.refFactory.createReference(tx, null);
        tx.commit();
        TestUtils.assertInstanceOf((Object)ref, AlphaProgrammaticReference.class);
    }
}

