/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticReference;

public class AlphaProgrammaticReference_constructionTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void noArgConstruction() {
        long version = this.stm.getVersion();
        AlphaProgrammaticReference ref = new AlphaProgrammaticReference();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.get());
    }

    @Test
    public void nullConstruction() {
        long version = this.stm.getVersion();
        AlphaProgrammaticReference ref = new AlphaProgrammaticReference();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals(null, (Object)ref.get());
    }

    @Test
    public void nonNullConstruction() {
        long version = this.stm.getVersion();
        String s = "foo";
        AlphaProgrammaticReference ref = new AlphaProgrammaticReference((Object)s);
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertEquals((Object)s, (Object)ref.get());
    }
}

