/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticReference;

public class AlphaProgrammaticReference_rollbackTest {
    private Stm stm;
    private TransactionFactory updateTxFactory;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        this.updateTxFactory = this.stm.getTransactionFactoryBuilder().setSpeculativeConfigurationEnabled(false).build();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void rollback() {
        this.rollback(null, null);
        this.rollback(null, "foo");
        this.rollback("bar", "foo");
        this.rollback("bar", null);
    }

    public void rollback(String initialValue, String newValue) {
        AlphaProgrammaticReference ref = new AlphaProgrammaticReference((Object)initialValue);
        long version = this.stm.getVersion();
        Transaction tx = this.updateTxFactory.start();
        ThreadLocalTransaction.setThreadLocalTransaction((Transaction)tx);
        ref.set((Object)newValue);
        tx.abort();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)initialValue, (Object)ref.get());
    }
}

