/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.programmatic;

import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.programmatic.ProgrammaticReference;
import org.multiverse.api.programmatic.ProgrammaticReferenceFactory;

public class AlphaProgrammaticReference_stackStressTest {
    private int threadCount = 10;
    private int transactionCount = 1000000;
    private int stackCapacity = 1000;
    private static final ProgrammaticReferenceFactory refFactory = GlobalStmInstance.getGlobalStmInstance().getProgrammaticReferenceFactoryBuilder().build();
    private Stack stack;

    @Before
    public void setUp() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.stack = new Stack();
    }

    @Before
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        TestThread[] producers = new ProducerThread[this.threadCount];
        TestThread[] consumers = new ConsumerThread[this.threadCount];
        for (int k = 0; k < this.threadCount; ++k) {
            producers[k] = new ProducerThread(k);
            consumers[k] = new ConsumerThread(k);
        }
        TestUtils.startAll((TestThread[])producers);
        TestUtils.startAll((TestThread[])consumers);
        TestUtils.joinAll((TestThread[])producers);
        TestUtils.joinAll((TestThread[])consumers);
    }

    static /* synthetic */ ProgrammaticReferenceFactory access$200() {
        return refFactory;
    }

    @TransactionalObject
    public class Stack<E> {
        private final ProgrammaticReference<Node<E>> head = AlphaProgrammaticReference_stackStressTest.access$200().atomicCreateReference(null);

        int size() {
            Node h = (Node)this.head.get();
            return h == null ? 0 : h.size;
        }

        void push(E item) {
            if (item == null) {
                throw new NullPointerException();
            }
            if (this.size() == AlphaProgrammaticReference_stackStressTest.this.stackCapacity) {
                StmUtils.retry();
            }
            this.head.set(new Node<E>(item, (Node)this.head.get()));
        }

        E pop() {
            if (this.head.isNull()) {
                StmUtils.retry();
            }
            Node h = (Node)this.head.get();
            this.head.set(h.next);
            return h.value;
        }

        class Node<E> {
            final E value;
            final Node<E> next;
            final int size;

            Node(E value, Node<E> next) {
                this.value = value;
                this.next = next;
                this.size = next == null ? 1 : next.size + 1;
            }
        }
    }

    public class ConsumerThread
    extends TestThread {
        public ConsumerThread(int id) {
            super("ConsumerThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < AlphaProgrammaticReference_stackStressTest.this.transactionCount; ++k) {
                this.produce();
                if (k % 100000 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
        }

        @TransactionalMethod
        private void produce() {
            AlphaProgrammaticReference_stackStressTest.this.stack.pop();
        }
    }

    public class ProducerThread
    extends TestThread {
        public ProducerThread(int id) {
            super("ProducerThread-" + id);
        }

        public void doRun() throws Exception {
            for (int k = 0; k < AlphaProgrammaticReference_stackStressTest.this.transactionCount; ++k) {
                this.produce();
                if (k % 100000 != 0) continue;
                System.out.printf("%s is at %s\n", this.getName(), k);
            }
        }

        @TransactionalMethod
        private void produce() {
            AlphaProgrammaticReference_stackStressTest.this.stack.push("foo");
        }
    }
}

