/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.transactions.readonly.ArrayReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class ArrayReadonlyAlphaTransaction_commitTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stm = new AlphaStm(this.stmConfig);
    }

    public ArrayReadonlyAlphaTransaction startTransactionUnderTest(int maximumSize) {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, true);
        return new ArrayReadonlyAlphaTransaction(config, maximumSize);
    }

    @Test
    public void whenEmpty() {
        ArrayReadonlyAlphaTransaction tx = this.startTransactionUnderTest(10);
        long version = this.stm.getVersion();
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenNoConflictingReads_thenCommitSuccess() {
        ManualRef ref = new ManualRef(this.stm);
        ArrayReadonlyAlphaTransaction tx = this.startTransactionUnderTest(10);
        tx.openForRead((AlphaTransactionalObject)ref);
        long version = this.stm.getVersion();
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenConflictingWritesAreFoundAfterOpenForRead_thenCommitSuccess() {
        ManualRef ref = new ManualRef(this.stm);
        ArrayReadonlyAlphaTransaction tx = this.startTransactionUnderTest(10);
        tx.openForRead((AlphaTransactionalObject)ref);
        ref.inc(this.stm);
        long version = this.stm.getVersion();
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }
}

