/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.annotations.TransactionalMethod;
import org.multiverse.annotations.TransactionalObject;
import org.multiverse.api.Listeners;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.NoRetryPossibleException;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.transactions.readonly.MapReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class MapReadonlyAlphaTransaction_registerRetryLatchTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stm = new AlphaStm(this.stmConfig);
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    public MapReadonlyAlphaTransaction startSutTransaction() {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, true);
        return new MapReadonlyAlphaTransaction(config);
    }

    @Test
    public void whenExplicitRetryNotAllowed_thenNoRetryPossibleException() {
        ManualRef ref = new ManualRef(this.stm);
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, true).withExplicitRetryAllowed(false);
        MapReadonlyAlphaTransaction tx = new MapReadonlyAlphaTransaction(config);
        tx.openForRead((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void whenNullLatch_thenNullPointerException() {
        MapReadonlyAlphaTransaction tx = this.startSutTransaction();
        try {
            tx.registerRetryLatch(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenEmptyReadSet_thenNoRetryPossibleException() {
        CheapLatch latch = new CheapLatch();
        MapReadonlyAlphaTransaction tx = this.startSutTransaction();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException noRetryPossibleException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)latch.isOpen());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenVersionNewer_thenLatchOpened() {
        ManualRef ref = new ManualRef(this.stm);
        CheapLatch latch = new CheapLatch();
        MapReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        ref.inc(this.stm);
        tx.registerRetryLatch((Latch)latch);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)latch.isOpen());
        Assert.assertNull((Object)ref.___getListeners());
    }

    @Test
    public void whenSingletonReadSet_thenLatchIsRegistered() {
        CheapLatch latch = new CheapLatch();
        ManualRef ref = new ManualRef(this.stm);
        MapReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        tx.registerRetryLatch((Latch)latch);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
        Listeners listeners = ref.___getListeners();
        Assert.assertNotNull((Object)listeners);
        Assert.assertSame((Object)latch, (Object)listeners.getListener());
        Assert.assertNull((Object)listeners.getNext());
    }

    @Test
    public void whenMultipleItemsRead_thenLatchIsRegisteredToAll() {
        CheapLatch latch = new CheapLatch();
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        MapReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref1);
        tx.openForRead((AlphaTransactionalObject)ref2);
        tx.registerRetryLatch((Latch)latch);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
        Listeners listeners1 = ref1.___getListeners();
        Assert.assertNotNull((Object)listeners1);
        Assert.assertSame((Object)latch, (Object)listeners1.getListener());
        Assert.assertNull((Object)listeners1.getNext());
        Listeners listener2 = ref2.___getListeners();
        Assert.assertNotNull((Object)listener2);
        Assert.assertSame((Object)latch, (Object)listener2.getListener());
        Assert.assertNull((Object)listener2.getNext());
    }

    @Test
    public void whenAlreadyContainsListener_newListenerAppended() {
        CheapLatch oldLatch = new CheapLatch();
        CheapLatch newLatch = new CheapLatch();
        ManualRef ref = new ManualRef(this.stm);
        MapReadonlyAlphaTransaction tx1 = this.startSutTransaction();
        tx1.openForRead((AlphaTransactionalObject)ref);
        tx1.registerRetryLatch((Latch)oldLatch);
        MapReadonlyAlphaTransaction tx2 = this.startSutTransaction();
        tx2.openForRead((AlphaTransactionalObject)ref);
        tx2.registerRetryLatch((Latch)newLatch);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx2});
        Assert.assertFalse((boolean)newLatch.isOpen());
        Listeners listeners = ref.___getListeners();
        Assert.assertNotNull((Object)listeners);
        Assert.assertSame((Object)newLatch, (Object)listeners.getListener());
        Assert.assertNotNull((Object)listeners.getNext());
        Assert.assertSame((Object)oldLatch, (Object)listeners.getNext().getListener());
        Assert.assertNull((Object)listeners.getNext().getNext());
    }

    @Test
    public void integrationTest() {
        SomeRef ref = new SomeRef(0);
        AwaitThread thread1 = new AwaitThread(ref);
        AwaitThread thread2 = new AwaitThread(ref);
        TestUtils.startAll((TestThread[])new TestThread[]{thread1, thread2});
        TestUtils.sleepMs((long)100L);
        Assert.assertTrue((boolean)thread1.isAlive());
        Assert.assertTrue((boolean)thread2.isAlive());
        ref.set(1);
        TestUtils.sleepMs((long)100L);
        TestUtils.joinAll((TestThread[])new TestThread[]{thread1, thread2});
    }

    @TransactionalObject
    static class SomeRef {
        int value;

        SomeRef(int value) {
            this.value = value;
        }

        public void set(int newValue) {
            this.value = newValue;
        }

        @TransactionalMethod(readonly=true, trackReads=true)
        public void await(int value) {
            if (this.value != value) {
                StmUtils.retry();
            }
        }
    }

    class AwaitThread
    extends TestThread {
        private final SomeRef ref;

        AwaitThread(SomeRef ref) {
            super("AwaitThread");
            this.ref = ref;
        }

        public void doRun() throws Exception {
            this.ref.await(1);
        }
    }
}

