/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.transactions.readonly.MapReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class MapReadonlyAlphaTransaction_restartTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MapReadonlyAlphaTransaction startSutTransaction() {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, true);
        return new MapReadonlyAlphaTransaction(config);
    }

    @Test
    public void whenUnused() {
        long version = this.stm.getVersion();
        MapReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.restart();
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)version, (Object)tx.getReadVersion());
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Map readMap = (Map)TestUtils.getField((Object)tx, (String)"attachedMap");
        Assert.assertTrue((boolean)readMap.isEmpty());
    }

    @Test
    public void whenUsed_thenReadMapIsCleared() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        MapReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref1);
        tx.openForRead((AlphaTransactionalObject)ref2);
        tx.restart();
        Map readMap = (Map)TestUtils.getField((Object)tx, (String)"attachedMap");
        Assert.assertTrue((boolean)readMap.isEmpty());
    }

    @Test
    public void whenOtherTxCommittedAfterThisTxStarted_thenReadVersionIncreased() {
        MapReadonlyAlphaTransaction tx = this.startSutTransaction();
        this.stmConfig.clock.tick();
        tx.restart();
        Assert.assertEquals((long)this.stm.getVersion(), (long)tx.getReadVersion());
    }

    @Test
    public void whenAborted_thenTxActivated() {
        MapReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.abort();
        tx.restart();
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenCommitted_thenTxActivated() {
        MapReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.commit();
        tx.restart();
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }
}

