/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.transactions.readonly.MonoReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class MonoReadonlyAlphaTransaction_abortTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createFastConfig();
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MonoReadonlyAlphaTransaction startSutTransaction() {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, true);
        return new MonoReadonlyAlphaTransaction(config);
    }

    @Test
    public void whenUnused() {
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenUsed_thenTxAborted() {
        ManualRef ref = new ManualRef(this.stm);
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }
}

