/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.DeadTransactionException;
import org.multiverse.api.exceptions.PreparedTransactionException;
import org.multiverse.api.exceptions.ReadonlyException;
import org.multiverse.api.exceptions.SpeculativeConfigurationFailure;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.transactions.SpeculativeConfiguration;
import org.multiverse.stms.alpha.transactions.readonly.MonoReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class MonoReadonlyAlphaTransaction_openForCommutingWriteTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createFastConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MonoReadonlyAlphaTransaction startSutTransaction() {
        return this.startSutTransaction(new SpeculativeConfiguration(100));
    }

    public MonoReadonlyAlphaTransaction startSutTransaction(SpeculativeConfiguration speculativeConfiguration) {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, true).withSpeculativeConfig(speculativeConfiguration);
        return new MonoReadonlyAlphaTransaction(config);
    }

    @Test
    public void whenExplicitReadonly_thenReadonlyException() {
        ManualRef ref = new ManualRef(this.stm);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(false, false, false, 100);
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction(speculativeConfig);
        long version = this.stm.getVersion();
        try {
            tx.openForCommutingWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (ReadonlyException expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)TestUtils.getField((Object)tx, (String)"attached"));
        Assert.assertTrue((boolean)speculativeConfig.isReadonly());
    }

    @Test
    public void whenSpeculativeReadonly_thenSpeculativeConfigurationFailure() {
        ManualRef ref = new ManualRef(this.stm);
        SpeculativeConfiguration speculativeConfig = new SpeculativeConfiguration(100);
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction(speculativeConfig);
        long version = this.stm.getVersion();
        try {
            tx.openForCommutingWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (SpeculativeConfigurationFailure expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertNull((Object)TestUtils.getField((Object)tx, (String)"attached"));
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertFalse((boolean)speculativeConfig.isReadonly());
    }

    @Test
    public void whenPrepared_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.prepare();
        long version = this.stm.getVersion();
        try {
            tx.openForCommutingWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (PreparedTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsPrepared((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenAborted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.abort();
        long version = this.stm.getVersion();
        try {
            tx.openForCommutingWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenCommitted_thenDeadTransactionException() {
        ManualRef ref = new ManualRef(this.stm);
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.commit();
        long version = this.stm.getVersion();
        try {
            tx.openForCommutingWrite((AlphaTransactionalObject)ref);
            Assert.fail();
        }
        catch (DeadTransactionException expected) {
            // empty catch block
        }
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }
}

