/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.NoRetryPossibleException;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.transactions.AlphaTransactionTestUtils;
import org.multiverse.stms.alpha.transactions.readonly.MonoReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class MonoReadonlyAlphaTransaction_registerRetryLatchTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createFastConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MonoReadonlyAlphaTransaction startSutTransaction() {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, true);
        return new MonoReadonlyAlphaTransaction(config);
    }

    @Test
    public void whenExplicitRetryNotAllowed_thenNoRetryPossibleException() {
        ManualRef ref = new ManualRef(this.stm);
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, true).withExplicitRetryAllowed(false);
        MonoReadonlyAlphaTransaction tx = new MonoReadonlyAlphaTransaction(config);
        tx.openForRead((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException expected) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
    }

    @Test
    public void whenUnused_thenNoRetryPossibleException() {
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        CheapLatch latch = new CheapLatch();
        try {
            tx.registerRetryLatch((Latch)latch);
            Assert.fail();
        }
        catch (NoRetryPossibleException noRetryPossibleException) {
            // empty catch block
        }
        Assert.assertFalse((boolean)latch.isOpen());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenNullLatch_thenNullPointerException() {
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        try {
            tx.registerRetryLatch(null);
            Assert.fail();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenLoadedForRead_thenListenerAdded() {
        ManualRef ref = new ManualRef(this.stm);
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        CheapLatch latch = new CheapLatch();
        tx.registerRetryLatch((Latch)latch);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
        AlphaTransactionTestUtils.assertHasListeners(ref, new Latch[]{latch});
    }

    @Test
    public void whenListenersAlreadyPresent_newListenerAppended() {
        ManualRef ref = new ManualRef(this.stm);
        CheapLatch latch1 = new CheapLatch();
        CheapLatch latch2 = new CheapLatch();
        MonoReadonlyAlphaTransaction tx1 = this.startSutTransaction();
        tx1.openForRead((AlphaTransactionalObject)ref);
        tx1.registerRetryLatch((Latch)latch1);
        MonoReadonlyAlphaTransaction tx2 = this.startSutTransaction();
        tx2.openForRead((AlphaTransactionalObject)ref);
        tx2.registerRetryLatch((Latch)latch2);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx2});
        Assert.assertFalse((boolean)latch1.isOpen());
        Assert.assertFalse((boolean)latch2.isOpen());
        AlphaTransactionTestUtils.assertHasListeners(ref, new Latch[]{latch2, latch1});
    }

    @Test
    public void whenVersionAlreadyThere_thenLatchOpenedAndNotRegistered() {
        ManualRef ref = new ManualRef(this.stm);
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        ref.inc(this.stm);
        CheapLatch latch = new CheapLatch();
        tx.registerRetryLatch((Latch)latch);
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertTrue((boolean)latch.isOpen());
        AlphaTransactionTestUtils.assertHasNoListeners(ref);
    }

    @Test
    public void integrationTest() {
        ManualRef ref = new ManualRef(this.stm);
        CheapLatch latch = new CheapLatch();
        MonoReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        tx.registerRetryLatch((Latch)latch);
        WaitThread waitThread = new WaitThread((Latch)latch);
        waitThread.start();
        TestUtils.sleepSome();
        TestUtils.assertAlive((Thread[])new Thread[]{waitThread});
        ref.inc(this.stm);
        TestUtils.sleepSome();
        TestUtils.joinAll((TestThread[])new TestThread[]{waitThread});
    }

    class WaitThread
    extends TestThread {
        final Latch latch;

        WaitThread(Latch latch) {
            super("WaitThread");
            this.latch = latch;
        }

        public void doRun() throws Exception {
            this.latch.awaitUninterruptible();
        }
    }
}

