/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.transactions.readonly.NonTrackingReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class NonTrackingReadonlyAlphaTransaction_abortTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public NonTrackingReadonlyAlphaTransaction startSutTransaction() {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, false);
        return new NonTrackingReadonlyAlphaTransaction(config);
    }

    @Test
    public void whenUnused() {
        long startVersion = this.stm.getVersion();
        NonTrackingReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.abort();
        Assert.assertEquals((long)startVersion, (long)this.stm.getVersion());
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenUsed() {
        ManualRef ref = new ManualRef(this.stm);
        long startVersion = this.stm.getVersion();
        NonTrackingReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        tx.abort();
        Assert.assertEquals((long)startVersion, (long)this.stm.getVersion());
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
    }
}

