/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.readonly;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.transactions.readonly.NonTrackingReadonlyAlphaTransaction;
import org.multiverse.stms.alpha.transactions.readonly.ReadonlyConfiguration;

public class NonTrackingReadonlyAlphaTransaction_restartTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public NonTrackingReadonlyAlphaTransaction startSutTransaction() {
        ReadonlyConfiguration config = new ReadonlyConfiguration(this.stmConfig.clock, false);
        return new NonTrackingReadonlyAlphaTransaction(config);
    }

    @Test
    public void whenUnusedAndNoOtherUpdates() {
        NonTrackingReadonlyAlphaTransaction tx = this.startSutTransaction();
        long expectedReadVersion = this.stm.getVersion();
        tx.restart();
        Assert.assertEquals((long)expectedReadVersion, (long)tx.getReadVersion());
        Assert.assertEquals((long)expectedReadVersion, (long)this.stm.getVersion());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenUnusedAndOtherUpdates() {
        NonTrackingReadonlyAlphaTransaction tx = this.startSutTransaction();
        this.stmConfig.clock.tick();
        long expectedReadVersion = this.stm.getVersion();
        tx.restart();
        Assert.assertEquals((long)expectedReadVersion, (long)tx.getReadVersion());
        Assert.assertEquals((long)expectedReadVersion, (long)this.stm.getVersion());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenPrepared() {
        NonTrackingReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.prepare();
        this.stmConfig.clock.tick();
        long version = this.stm.getVersion();
        tx.restart();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)tx.getReadVersion());
    }

    @Test
    public void whenAborted() {
        NonTrackingReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.abort();
        this.stmConfig.clock.tick();
        long version = this.stm.getVersion();
        tx.restart();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)tx.getReadVersion());
    }

    @Test
    public void whenCommitted() {
        NonTrackingReadonlyAlphaTransaction tx = this.startSutTransaction();
        tx.commit();
        this.stmConfig.clock.tick();
        long version = this.stm.getVersion();
        tx.restart();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)tx.getReadVersion());
    }
}

