/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.WriteSkewConflict;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLong;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.AlphaTransactionTestUtils;
import org.multiverse.stms.alpha.transactions.update.ArrayUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class ArrayUpdateAlphaTransaction_commitTest {
    private AlphaStmConfig stmConfig;
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public AlphaTransaction startSutTransaction(int size) {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock);
        return new ArrayUpdateAlphaTransaction(config, size);
    }

    @Test
    public void whenUnused_thenCommitSuccess() {
        AlphaTransaction tx = this.startSutTransaction(2);
        tx.commit();
        long version = this.stm.getVersion();
        tx.commit();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenOnlyFreshObjects_thenVersionNotIncreased() {
        ManualRef txObject = ManualRef.createUncommitted();
        AlphaTransaction tx = this.startSutTransaction(2);
        AlphaTranlocal tranlocal = tx.openForConstruction((AlphaTransactionalObject)txObject);
        long version = this.stm.getVersion();
        tx.commit();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)tranlocal, (Object)txObject.___load());
        Assert.assertSame((Object)this.stm.getVersion(), (Object)tranlocal.getWriteVersion());
        Assert.assertSame((Object)((Object)txObject), (Object)tranlocal.getTransactionalObject());
        Assert.assertNull((Object)txObject.___getLockOwner());
    }

    @Test
    public void freshObjectIsNotLocked() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = ManualRef.createUncommitted();
        AlphaTransaction tx = this.startSutTransaction(2);
        ref1.inc(tx);
        AlphaTranlocal tranlocal2 = tx.openForConstruction((AlphaTransactionalObject)ref2);
        long version = this.stm.getVersion();
        ref1.resetLockInfo();
        ref2.resetLockInfo();
        tx.commit();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        ref2.assertNoLockAcquired();
        ref1.assertLockAcquired();
        Assert.assertNull((Object)ref1.___getLockOwner());
        Assert.assertNull((Object)ref2.___getLockOwner());
    }

    @Test
    public void whenDirty() {
        ManualRef txObject = new ManualRef(this.stm);
        AlphaTransaction tx = this.startSutTransaction(2);
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)txObject);
        ++tranlocal.value;
        long version = this.stm.getVersion();
        tx.commit();
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertSame((Object)((Object)tranlocal), (Object)txObject.___load());
        Assert.assertSame((Object)this.stm.getVersion(), (Object)tranlocal.getWriteVersion());
        Assert.assertSame((Object)((Object)txObject), (Object)tranlocal.getTransactionalObject());
        Assert.assertNull((Object)txObject.___getLockOwner());
    }

    @Test
    public void whenCommutingWrites() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(1L);
        AlphaTransaction tx = this.startSutTransaction(10);
        ref.commutingInc((Transaction)tx, 1L);
        AlphaTranlocal tranlocal = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        Assert.assertTrue((boolean)tranlocal.isCommuting());
        long version = this.stm.getVersion();
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)2L, (long)ref.atomicGet());
        Assert.assertSame((Object)tranlocal, (Object)ref.___load());
        Assert.assertTrue((boolean)tranlocal.isCommitted());
        Assert.assertEquals((long)(version + 1L), (long)tranlocal.getWriteVersion());
        Assert.assertNull((Object)tranlocal.getOrigin());
    }

    @Test
    public void whenListenersRegistered_theyAreRemovedAndNotified() {
        ManualRef ref = new ManualRef(this.stm);
        CheapLatch latch1 = new CheapLatch();
        CheapLatch latch2 = new CheapLatch();
        this.registerRetryListener(ref, (Latch)latch1);
        this.stmConfig.clock.tick();
        this.registerRetryListener(ref, (Latch)latch2);
        AlphaTransaction tx = this.startSutTransaction(10);
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ++tranlocal.value;
        tx.commit();
        AlphaTransactionTestUtils.assertHasNoListeners(ref);
        Assert.assertTrue((boolean)latch1.isOpen());
        Assert.assertTrue((boolean)latch2.isOpen());
    }

    private void registerRetryListener(ManualRef ref, Latch latch) {
        AlphaTransaction listenTx = (AlphaTransaction)this.stm.getTransactionFactoryBuilder().setReadonly(false).setReadTrackingEnabled(true).setExplicitRetryAllowed(true).build().start();
        listenTx.openForRead((AlphaTransactionalObject)ref);
        listenTx.registerRetryLatch(latch);
    }

    @Test
    public void complexScenario() {
        ManualRef updateRef = new ManualRef(this.stm, 0);
        ManualRef readonlyRef = new ManualRef(this.stm, 0);
        ManualRef freshRef = ManualRef.createUncommitted();
        AlphaTransaction tx = this.startSutTransaction(3);
        ManualRefTranlocal updateTranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)updateRef);
        ++updateTranlocal.value;
        tx.openForRead((AlphaTransactionalObject)readonlyRef);
        ManualRefTranlocal freshTranlocal = (ManualRefTranlocal)tx.openForConstruction((AlphaTransactionalObject)freshRef);
        ++freshTranlocal.value;
        long version = this.stm.getVersion();
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)1L, (long)updateRef.get(this.stm));
        Assert.assertEquals((long)0L, (long)readonlyRef.get(this.stm));
        Assert.assertEquals((long)1L, (long)freshRef.get(this.stm));
    }

    @Test
    public void whenWriteSkewAllowed_thenCommit() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock);
        ArrayUpdateAlphaTransaction tx1 = new ArrayUpdateAlphaTransaction(config, 10);
        tx1.openForRead((AlphaTransactionalObject)ref1);
        ref2.inc((AlphaTransaction)tx1);
        ArrayUpdateAlphaTransaction tx2 = new ArrayUpdateAlphaTransaction(config, 10);
        tx2.openForRead((AlphaTransactionalObject)ref2);
        ref1.inc((AlphaTransaction)tx2);
        tx1.commit();
        tx2.commit();
        Assert.assertEquals((long)1L, (long)ref1.get(this.stm));
        Assert.assertEquals((long)1L, (long)ref2.get(this.stm));
    }

    @Test
    public void whenWriteSkewDisallowed_thenWriteSkewConflict() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withWriteSkewAllowed(false);
        ArrayUpdateAlphaTransaction tx1 = new ArrayUpdateAlphaTransaction(config, 10);
        tx1.openForRead((AlphaTransactionalObject)ref1);
        ref2.inc((AlphaTransaction)tx1);
        ArrayUpdateAlphaTransaction tx2 = new ArrayUpdateAlphaTransaction(config, 10);
        tx2.openForRead((AlphaTransactionalObject)ref2);
        ref1.inc((AlphaTransaction)tx2);
        tx1.commit();
        try {
            tx2.commit();
            Assert.fail();
        }
        catch (WriteSkewConflict expected) {
            // empty catch block
        }
        Assert.assertEquals((long)0L, (long)ref1.get(this.stm));
        Assert.assertEquals((long)1L, (long)ref2.get(this.stm));
    }
}

