/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.ArrayUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class ArrayUpdateAlphaTransaction_restartTest {
    private AlphaStmConfig stmConfig;
    private AlphaStm stm;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public AlphaTransaction startSutTransaction(int size) {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock);
        return new ArrayUpdateAlphaTransaction(config, size);
    }

    @Test
    public void whenUnused() {
        AlphaTransaction tx = this.startSutTransaction(10);
        tx.restart();
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((Object)0, (Object)TestUtils.getField((Object)tx, (String)"firstFreeIndex"));
    }

    @Test
    public void whenUsed() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRefTranlocal committed1 = (ManualRefTranlocal)ref1.___load();
        ManualRef ref2 = new ManualRef(this.stm);
        ManualRefTranlocal committed2 = (ManualRefTranlocal)ref2.___load();
        AlphaTransaction tx = this.startSutTransaction(10);
        tx.openForWrite((AlphaTransactionalObject)ref1);
        tx.openForRead((AlphaTransactionalObject)ref2);
        tx.restart();
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((Object)0, (Object)TestUtils.getField((Object)tx, (String)"firstFreeIndex"));
        Assert.assertSame((Object)((Object)committed1), (Object)ref1.___load());
        Assert.assertSame((Object)((Object)committed2), (Object)ref2.___load());
    }

    @Test
    public void whenPreparedWithLockedResources_thenResourcesFreed() {
        ManualRef ref = new ManualRef(this.stm);
        AlphaTransaction tx = this.startSutTransaction(10);
        ref.inc(tx);
        tx.prepare();
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertNull((Object)ref.___getLockOwner());
    }
}

