/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import java.util.Map;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.MapUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class MapUpdateAlphaTransaction_restartTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MapUpdateAlphaTransaction startSutTransaction() {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock);
        return new MapUpdateAlphaTransaction(config);
    }

    @Test
    public void whenUnused() {
        MapUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.restart();
        Assert.assertEquals((long)this.stm.getVersion(), (long)tx.getReadVersion());
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
    }

    @Test
    public void whenUsed() {
        ManualRef ref = new ManualRef(this.stm, 1);
        MapUpdateAlphaTransaction tx = this.startSutTransaction();
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ++tranlocal.value;
        tx.restart();
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)this.stm.getVersion(), (long)tx.getReadVersion());
    }

    @Test
    public void whenAborted() {
        MapUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.abort();
        tx.restart();
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)this.stm.getVersion(), (long)tx.getReadVersion());
    }

    @Test
    public void whenPreparedWithLockedResources_thenResourcesFreed() {
        ManualRef ref = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx = this.startSutTransaction();
        ref.inc((AlphaTransaction)tx);
        tx.prepare();
        tx.restart();
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenCommitted() {
        MapUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.commit();
        tx.restart();
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)this.stm.getVersion(), (long)tx.getReadVersion());
    }

    @Test
    public void whenVersionUpdatedByOtherTx_thenTxUpdatesReadVersion() {
        MapUpdateAlphaTransaction tx = this.startSutTransaction();
        this.stmConfig.clock.tick();
        tx.restart();
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)this.stm.getVersion(), (long)tx.getReadVersion());
    }

    @Test
    public void whenReadWriteMapNonEmpty_thenItIsCleared() {
        ManualRef ref1 = new ManualRef(this.stm);
        ManualRef ref2 = new ManualRef(this.stm);
        MapUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref1);
        tx.openForWrite((AlphaTransactionalObject)ref2);
        tx.restart();
        Map readWriteMap = (Map)TestUtils.getField((Object)tx, (String)"attachedMap");
        Assert.assertTrue((boolean)readWriteMap.isEmpty());
    }
}

