/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.AlphaTransactionTestUtils;
import org.multiverse.stms.alpha.transactions.update.MonoUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class MonoUpdateAlphaTransaction_abortTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MonoUpdateAlphaTransaction startSutTransaction() {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock);
        return new MonoUpdateAlphaTransaction(config);
    }

    @Test
    public void whenUnused() {
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        long version = this.stm.getVersion();
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
    }

    @Test
    public void whenReadonly() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        long version = this.stm.getVersion();
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)((Object)committed), (Object)ref.___load());
    }

    @Test
    public void whenUpdates() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.openForWrite((AlphaTransactionalObject)ref);
        long version = this.stm.getVersion();
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)((Object)committed), (Object)ref.___load());
    }

    @Test
    public void whenDirty_changesAreDiscarded() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ++tranlocal.value;
        long version = this.stm.getVersion();
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)((Object)committed), (Object)ref.___load());
    }

    @Test
    public void whenFresh_changesAreDiscarded() {
        ManualRef ref = ManualRef.createUncommitted();
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.openForConstruction((AlphaTransactionalObject)ref);
        long version = this.stm.getVersion();
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertNull((Object)ref.___load());
    }

    @Test
    public void whenDirty_noListenersAreNotified() {
        ManualRef ref = new ManualRef(this.stm);
        CheapLatch latch = new CheapLatch();
        AlphaTransaction listenTx = (AlphaTransaction)this.stm.getTransactionFactoryBuilder().setReadonly(false).setReadTrackingEnabled(true).setExplicitRetryAllowed(true).build().start();
        listenTx.openForRead((AlphaTransactionalObject)ref);
        listenTx.registerRetryLatch((Latch)latch);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ++tranlocal.value;
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertFalse((boolean)latch.isOpen());
        AlphaTransactionTestUtils.assertHasListeners(ref, new Latch[]{latch});
    }

    @Test
    public void whenPreparedWithLockedResources_thenResourcesFreed() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        ref.inc((AlphaTransaction)tx);
        tx.prepare();
        tx.abort();
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertNull((Object)ref.___getLockOwner());
    }
}

