/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.api.exceptions.OptimisticLockFailedWriteConflict;
import org.multiverse.api.latches.CheapLatch;
import org.multiverse.api.latches.Latch;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTranlocal;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.programmatic.AlphaProgrammaticLong;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.AlphaTransactionTestUtils;
import org.multiverse.stms.alpha.transactions.update.MonoUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class MonoUpdateAlphaTransaction_commitTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MonoUpdateAlphaTransaction startSutTransaction() {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock).withReadTrackingEnabled(true).withExplictRetryAllowed(true);
        return new MonoUpdateAlphaTransaction(config);
    }

    @Test
    public void freshObjectIsNotLocked() {
        ManualRef ref = ManualRef.createUncommitted();
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.openForConstruction((AlphaTransactionalObject)ref);
        long version = this.stm.getVersion();
        ref.resetLockInfo();
        tx.commit();
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        ref.assertNoLockAcquired();
        ref.assertNoLocksReleased();
    }

    @Test
    public void whenUnused_thenCommitSucceedsWithoutChange() {
        long startTime = this.stm.getVersion();
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)startTime, (long)this.stm.getVersion());
    }

    @Test
    public void whenReadonly_thenCommitSucceedsWithoutChange() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)((Object)committed), (Object)ref.___load());
        Assert.assertNull((Object)ref.___getListeners());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenUpdate_updatedTranlocalIsWritten() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.openForWrite((AlphaTransactionalObject)ref);
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)((Object)committed), (Object)ref.___load());
        Assert.assertNull((Object)ref.___getListeners());
        Assert.assertNull((Object)ref.___getLockOwner());
    }

    @Test
    public void whenDirty_newTranlocalIsWritten() {
        ManualRef ref = new ManualRef(this.stm);
        long version = this.stm.getVersion();
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ++tranlocal.value;
        Assert.assertNull((Object)ref.___getLockOwner());
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertSame((Object)((Object)tranlocal), (Object)ref.___load());
        Assert.assertNull((Object)ref.___getListeners());
        Assert.assertTrue((boolean)tranlocal.isCommitted());
    }

    @Test
    public void whenCommutingWrites() {
        AlphaProgrammaticLong ref = new AlphaProgrammaticLong(1L);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        ref.commutingInc((Transaction)tx, 1L);
        AlphaTranlocal tranlocal = tx.openForCommutingWrite((AlphaTransactionalObject)ref);
        Assert.assertTrue((boolean)tranlocal.isCommuting());
        long version = this.stm.getVersion();
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)(version + 1L), (long)this.stm.getVersion());
        Assert.assertEquals((long)2L, (long)ref.atomicGet());
        Assert.assertSame((Object)tranlocal, (Object)ref.___load());
        Assert.assertTrue((boolean)tranlocal.isCommitted());
        Assert.assertEquals((long)(version + 1L), (long)tranlocal.getWriteVersion());
        Assert.assertNull((Object)tranlocal.getOrigin());
    }

    @Test
    public void whenFresh_commitSucceeds() {
        ManualRef ref = ManualRef.createUncommitted();
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForConstruction((AlphaTransactionalObject)ref);
        long version = this.stm.getVersion();
        tx.commit();
        TestUtils.assertIsCommitted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)((Object)tranlocal), (Object)ref.___load());
        Assert.assertNull((Object)ref.___getListeners());
        Assert.assertNull((Object)ref.___getLockOwner());
        Assert.assertNull((Object)tranlocal.getOrigin());
        Assert.assertEquals((long)this.stm.getVersion(), (long)tranlocal.getWriteVersion());
    }

    @Test
    public void whenWriteConflict_thenVersionTooOldWriteConflict() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ++tranlocal.value;
        ref.inc(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        long version = this.stm.getVersion();
        try {
            tx.commit();
            Assert.fail();
        }
        catch (OptimisticLockFailedWriteConflict ex) {
            // empty catch block
        }
        TestUtils.assertIsAborted((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)version, (long)this.stm.getVersion());
        Assert.assertSame((Object)((Object)committed), (Object)ref.___load());
    }

    @Test
    public void whenChange_listenersAreNotified() {
        ManualRef ref = new ManualRef(this.stm);
        CheapLatch latch1 = new CheapLatch();
        CheapLatch latch2 = new CheapLatch();
        this.registerRetryListener(ref, (Latch)latch1);
        this.stmConfig.clock.tick();
        this.registerRetryListener(ref, (Latch)latch2);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        ManualRefTranlocal tranlocal = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ++tranlocal.value;
        tx.commit();
        AlphaTransactionTestUtils.assertHasNoListeners(ref);
        Assert.assertTrue((boolean)latch1.isOpen());
        Assert.assertTrue((boolean)latch2.isOpen());
    }

    private void registerRetryListener(ManualRef ref, Latch latch) {
        AlphaTransaction listenTx = (AlphaTransaction)this.stm.getTransactionFactoryBuilder().setReadonly(false).setReadTrackingEnabled(true).setExplicitRetryAllowed(true).build().start();
        listenTx.openForRead((AlphaTransactionalObject)ref);
        listenTx.registerRetryLatch(latch);
    }

    @Test
    public void integrationTest() {
        ManualRef ref = new ManualRef(this.stm, 25);
        for (int k = 0; k < 100; ++k) {
            MonoUpdateAlphaTransaction tx = this.startSutTransaction();
            ref.inc((AlphaTransaction)tx);
            tx.commit();
        }
        Assert.assertEquals((long)125L, (long)ref.get(this.stm));
    }
}

