/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.stms.alpha.transactions.update;

import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestUtils;
import org.multiverse.api.Transaction;
import org.multiverse.stms.alpha.AlphaStm;
import org.multiverse.stms.alpha.AlphaStmConfig;
import org.multiverse.stms.alpha.AlphaTransactionalObject;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRef;
import org.multiverse.stms.alpha.manualinstrumentation.ManualRefTranlocal;
import org.multiverse.stms.alpha.transactions.AlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.MonoUpdateAlphaTransaction;
import org.multiverse.stms.alpha.transactions.update.UpdateConfiguration;

public class MonoUpdateAlphaTransaction_restartTest {
    private AlphaStm stm;
    private AlphaStmConfig stmConfig;

    @Before
    public void setUp() {
        this.stmConfig = AlphaStmConfig.createDebugConfig();
        this.stmConfig.maxRetries = 10;
        this.stm = new AlphaStm(this.stmConfig);
    }

    public MonoUpdateAlphaTransaction startSutTransaction() {
        UpdateConfiguration config = new UpdateConfiguration(this.stmConfig.clock);
        return new MonoUpdateAlphaTransaction(config);
    }

    @Test
    public void whenUnused() {
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.restart();
        this.assertRestartedCorrectly((AlphaTransaction)tx);
    }

    @Test
    public void whenOpenForRead_thenAttachedIsCleared() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.openForRead((AlphaTransactionalObject)ref);
        tx.restart();
        this.assertRestartedCorrectly((AlphaTransaction)tx);
    }

    @Test
    public void whenOpenForWrite_thenAttachedIsCleared() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        tx.openForWrite((AlphaTransactionalObject)ref);
        tx.restart();
        this.assertRestartedCorrectly((AlphaTransaction)tx);
    }

    @Test
    public void whenOtherTxCommitted_thenTxReadVersionIncreased() {
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        this.stmConfig.clock.tick();
        tx.restart();
        this.assertRestartedCorrectly((AlphaTransaction)tx);
    }

    @Test
    public void whenPendingWrites_theseAreDiscarded() {
        ManualRef ref = new ManualRef(this.stm);
        ManualRefTranlocal committed = (ManualRefTranlocal)ref.___load();
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        ManualRefTranlocal dirty = (ManualRefTranlocal)tx.openForWrite((AlphaTransactionalObject)ref);
        ++dirty.value;
        tx.restart();
        this.assertRestartedCorrectly((AlphaTransaction)tx);
        Assert.assertSame((Object)((Object)committed), (Object)ref.___load());
    }

    private void assertRestartedCorrectly(AlphaTransaction tx) {
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertEquals((long)this.stm.getVersion(), (long)tx.getReadVersion());
        Assert.assertNull((Object)TestUtils.getField((Object)tx, (String)"attached"));
    }

    @Test
    public void whenPreparedWithLockedResources_thenResourcesFreed() {
        ManualRef ref = new ManualRef(this.stm);
        MonoUpdateAlphaTransaction tx = this.startSutTransaction();
        ref.inc((AlphaTransaction)tx);
        tx.prepare();
        tx.restart();
        TestUtils.assertIsActive((Transaction[])new Transaction[]{tx});
        Assert.assertNull((Object)ref.___getLockOwner());
    }
}

