/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import java.util.concurrent.TimeUnit;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.StmUtils;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.api.TransactionFactory;
import org.multiverse.api.exceptions.RetryTimeoutException;
import org.multiverse.templates.TransactionTemplate;
import org.multiverse.transactional.DefaultTransactionalReference;
import org.multiverse.transactional.TransactionalReference;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class TransactionTemplate_TimeoutLongTest {
    private Stm stm;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void whenTimeout() {
        DefaultTransactionalReference ref = new DefaultTransactionalReference();
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setTimeoutNs(TimeUnit.SECONDS.toNanos(1L)).build();
        TransactionTemplate t = new TransactionTemplate(txFactory, (TransactionalReference)ref){
            final /* synthetic */ TransactionalReference val$ref;
            {
                this.val$ref = transactionalReference;
                super(x0);
            }

            public Object execute(Transaction tx) throws Exception {
                System.out.println(this.val$ref.get());
                if (this.val$ref.isNull()) {
                    StmUtils.retry();
                }
                return null;
            }
        };
        try {
            t.execute();
            Assert.fail();
        }
        catch (RetryTimeoutException expected) {
            // empty catch block
        }
    }

    @Test
    public void whenSomeWaitingNeeded() {
        final TransactionalInteger ref = new TransactionalInteger();
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setTimeoutNs(TimeUnit.SECONDS.toNanos(10L)).build();
        TransactionTemplate t = new TransactionTemplate(txFactory){

            public Object execute(Transaction tx) throws Exception {
                System.out.println("ref.value=" + ref.get());
                if (ref.get() < 50) {
                    StmUtils.retry();
                }
                return null;
            }
        };
        TestThread notifyThread = new TestThread(){

            public void doRun() throws Exception {
                for (int k = 0; k < 100; ++k) {
                    ref.inc();
                    TestUtils.sleepMs((long)100L);
                }
            }
        };
        notifyThread.start();
        t.execute();
        TestUtils.joinAll((TestThread[])new TestThread[]{notifyThread});
    }

    @Test
    public void multipleWakeupsButNotEnough() {
        final TransactionalInteger ref = new TransactionalInteger();
        TransactionFactory txFactory = this.stm.getTransactionFactoryBuilder().setTimeoutNs(TimeUnit.SECONDS.toNanos(5L)).build();
        TransactionTemplate t = new TransactionTemplate(txFactory){

            public Object execute(Transaction tx) throws Exception {
                System.out.println("ref.value=" + ref.get());
                if (ref.get() < 10000) {
                    StmUtils.retry();
                }
                return null;
            }
        };
        TestThread notifyThread = new TestThread(){

            public void doRun() throws Exception {
                for (int k = 0; k < 100; ++k) {
                    ref.inc();
                    TestUtils.sleepMs((long)100L);
                }
            }
        };
        notifyThread.start();
        try {
            t.execute();
            Assert.fail();
        }
        catch (RetryTimeoutException expected) {
            // empty catch block
        }
        TestUtils.joinAll((TestThread[])new TestThread[]{notifyThread});
    }
}

