/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.templates;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.multiverse.TestThread;
import org.multiverse.TestUtils;
import org.multiverse.api.GlobalStmInstance;
import org.multiverse.api.Stm;
import org.multiverse.api.ThreadLocalTransaction;
import org.multiverse.api.Transaction;
import org.multiverse.templates.TransactionTemplate;
import org.multiverse.transactional.primitives.TransactionalInteger;

public class TransactionTemplate_blockingTransactionTest {
    private Stm stm;
    private TransactionalInteger ref;

    @Before
    public void setUp() {
        this.stm = GlobalStmInstance.getGlobalStmInstance();
        ThreadLocalTransaction.clearThreadLocalTransaction();
        this.ref = new TransactionalInteger(0);
    }

    @After
    public void tearDown() {
        ThreadLocalTransaction.clearThreadLocalTransaction();
    }

    @Test
    public void test() {
        WaiterThread thread1 = new WaiterThread(0);
        WaiterThread thread2 = new WaiterThread(1);
        WaiterThread thread3 = new WaiterThread(2);
        TestUtils.startAll((TestThread[])new TestThread[]{thread1, thread2, thread3});
        TestUtils.joinAll((TestThread[])new TestThread[]{thread1});
        TestUtils.assertAlive((Thread[])new Thread[]{thread2, thread3});
        this.ref.set(1);
        TestUtils.joinAll((TestThread[])new TestThread[]{thread2});
        TestUtils.assertAlive((Thread[])new Thread[]{thread3});
        this.ref.set(2);
        TestUtils.joinAll((TestThread[])new TestThread[]{thread3});
    }

    class WaiterThread
    extends TestThread {
        private final int number;

        public WaiterThread(int number) {
            super("WaiterThread-" + number);
            this.number = number;
        }

        public void doRun() throws Exception {
            new TransactionTemplate(){

                public Object execute(Transaction tx) throws Exception {
                    TransactionTemplate_blockingTransactionTest.this.ref.await(WaiterThread.this.number);
                    return null;
                }
            }.execute();
        }
    }
}

